/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class PairedAlignment
implements Alignment {
    String readName;
    String chr;
    int start;
    int end;
    Alignment firstAlignment;
    Alignment secondAlignment;
    AlignmentBlock[] insertions;

    public PairedAlignment(Alignment firstAlignment) {
        this.firstAlignment = firstAlignment;
        this.start = firstAlignment.getStart();
        this.end = firstAlignment.getEnd();
        this.chr = firstAlignment.getChr();
    }

    public void setSecondAlignment(Alignment alignment) {
        this.secondAlignment = alignment;
        this.end = this.secondAlignment.getEnd();
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    public String getChromosome() {
        return this.chr;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getAlignmentStart() {
        return this.start;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return new AlignmentBlockImpl[0];
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        if (this.insertions == null) {
            AlignmentBlock[] block1 = this.firstAlignment.getInsertions();
            if (this.secondAlignment == null) {
                this.insertions = block1;
            } else {
                AlignmentBlock[] block2 = this.secondAlignment.getInsertions();
                this.insertions = new AlignmentBlockImpl[block1.length + block2.length];
                System.arraycopy(block1, 0, this.insertions, 0, block1.length);
                System.arraycopy(block2, 0, this.insertions, block1.length, block2.length);
            }
        }
        return this.insertions;
    }

    @Override
    public char[] getGapTypes() {
        return new char[0];
    }

    @Override
    public int getInferredInsertSize() {
        return Math.abs(this.firstAlignment.getInferredInsertSize());
    }

    @Override
    public int getMappingQuality() {
        if (this.secondAlignment == null) {
            return this.firstAlignment.getMappingQuality();
        }
        return Math.max(this.firstAlignment.getMappingQuality(), this.secondAlignment.getMappingQuality());
    }

    @Override
    public boolean isDuplicate() {
        return this.firstAlignment.isDuplicate() && (this.secondAlignment == null || this.secondAlignment.isDuplicate());
    }

    @Override
    public boolean isProperPair() {
        return true;
    }

    @Override
    public int getAlignmentEnd() {
        return this.end;
    }

    @Override
    public byte getBase(double position) {
        if (this.firstAlignment.contains(position)) {
            return this.firstAlignment.getBase(position);
        }
        if (this.secondAlignment != null && this.secondAlignment.contains(position)) {
            return this.secondAlignment.getBase(position);
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        if (this.firstAlignment.contains(position)) {
            return this.firstAlignment.getPhred(position);
        }
        if (this.secondAlignment != null && this.secondAlignment.contains(position)) {
            return this.secondAlignment.getPhred(position);
        }
        return 0;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        if (this.secondAlignment != null) {
            buf.append("<table><tr><td valign=\"top\">");
        }
        buf.append("<b>Left alignment</b><br/>");
        buf.append(this.firstAlignment.getValueString(position, windowFunction));
        if (this.secondAlignment != null) {
            buf.append("</td><td valign=\"top\">");
            buf.append("<b>Right alignment</b><br/>");
            buf.append(this.secondAlignment.getValueString(position, windowFunction));
            buf.append("</td></tr></table>");
        }
        return buf.toString();
    }

    @Override
    public String getClipboardString(double position) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>Left alignment</b><br/>");
        buf.append(this.firstAlignment.getClipboardString(position));
        if (this.secondAlignment != null) {
            buf.append("<br/><b>Right alignment</b><br/>");
            buf.append(this.secondAlignment.getClipboardString(position));
        }
        return buf.toString();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.end;
    }

    @Override
    public String getReadSequence() {
        return null;
    }

    @Override
    public String getCigarString() {
        return null;
    }

    @Override
    public ReadMate getMate() {
        return null;
    }

    @Override
    public boolean isPaired() {
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return false;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public void setMateSequence(String sequence) {
    }

    @Override
    public String getPairOrientation() {
        return null;
    }

    public boolean isSmallInsert() {
        return false;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public String getLibrary() {
        return this.firstAlignment.getLibrary();
    }

    @Override
    public void setStart(int start) {
    }

    @Override
    public void setEnd(int end) {
    }

    @Override
    public float getScore() {
        return 0.0f;
    }

    public LocusScore copy() {
        return null;
    }

    public Alignment getFirstAlignment() {
        return this.firstAlignment;
    }

    public Alignment getSecondAlignment() {
        return this.secondAlignment;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstAlignment.getFirstOfPairStrand();
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.firstAlignment.getSecondOfPairStrand();
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public void finish() {
        this.firstAlignment.finish();
        if (this.secondAlignment != null) {
            this.secondAlignment.finish();
        }
    }

    @Override
    public boolean isPrimary() {
        return this.firstAlignment.isPrimary() && (this.secondAlignment == null || this.secondAlignment.isPrimary());
    }

    @Override
    public boolean isSupplementary() {
        return this.firstAlignment.isSupplementary() && (this.secondAlignment == null || this.secondAlignment.isSupplementary());
    }
}

