/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class FreqData {
    public static float DEFAULT_AMP_THRESHOLD = 0.1f;
    public static float DEFAULT_DEL_THRESHOLD = -0.1f;
    public static int DEFAULT_BIN_SIZE = 200000;
    private float ampThreshold = DEFAULT_AMP_THRESHOLD;
    private float delThreshold = DEFAULT_DEL_THRESHOLD;
    private int binSize = DEFAULT_BIN_SIZE;
    private SegmentedDataSet dataset;
    private int numberOfSamples;
    private Map<String, List<LocusScore>> amp;
    private Map<String, List<LocusScore>> del;
    private List<String> sampleNames;
    Genome genome;

    public FreqData(SegmentedDataSet ds, Genome genome) {
        this.dataset = ds;
        this.sampleNames = ds.getSampleNames();
        this.numberOfSamples = this.sampleNames.size();
        this.amp = new HashMap<String, List<LocusScore>>();
        this.del = new HashMap<String, List<LocusScore>>();
        this.genome = genome;
        this.compute();
    }

    public void setParameters(int binSize, float delThreshold, float ampThreshold) {
        this.binSize = binSize;
        this.delThreshold = delThreshold;
        this.ampThreshold = ampThreshold;
        this.compute();
    }

    void compute() {
        this.amp.clear();
        this.del.clear();
        int sizeInKB = (int)(this.genome.getNominalLength() / 1000L);
        int wgBinSize = sizeInKB / 700;
        int wgBinCount = sizeInKB / wgBinSize + 1;
        for (String chr : this.genome.getAllChromosomeNames()) {
            Chromosome c2 = this.genome.getChromosome(chr);
            int len = c2.getLength();
            int nBins = len / this.binSize + 1;
            ArrayList<Bin> ampBins = new ArrayList<Bin>(nBins);
            ArrayList<Bin> delBins = new ArrayList<Bin>(nBins);
            for (int i2 = 0; i2 < nBins; ++i2) {
                int start = i2 * this.binSize;
                int end = start + this.binSize;
                ampBins.add(new Bin(chr, start, end));
                delBins.add(new Bin(chr, start, end));
            }
            this.amp.put(chr, ampBins);
            this.del.put(chr, delBins);
        }
        ArrayList<Bin> ampBins = new ArrayList<Bin>(wgBinCount);
        ArrayList<Bin> delBins = new ArrayList<Bin>(wgBinCount);
        for (int i3 = 0; i3 < wgBinCount; ++i3) {
            int start = i3 * wgBinSize;
            int end = start + wgBinSize;
            ampBins.add(new Bin("All", start, end));
            delBins.add(new Bin("All", start, end));
        }
        this.amp.put("All", ampBins);
        this.del.put("All", delBins);
        HashSet<String> wgChromosomes = new HashSet<String>(this.genome.getLongChromosomeNames());
        boolean logNormalized = this.dataset.isLogNormalized();
        for (String sample : this.sampleNames) {
            for (String chr : this.genome.getLongChromosomeNames()) {
                List<LocusScore> segments = this.dataset.getSegments(sample, chr);
                if (segments == null) continue;
                for (LocusScore seg : segments) {
                    float segScore;
                    float f2 = segScore = logNormalized ? seg.getScore() : (float)(Math.log(seg.getScore() / 2.0f) / Globals.log2);
                    if (!(segScore > this.ampThreshold) && !(segScore < this.delThreshold)) continue;
                    int startBin = seg.getStart() / this.binSize;
                    int endBin = seg.getEnd() / this.binSize;
                    for (int b2 = startBin; b2 <= endBin && b2 < this.amp.get(chr).size(); ++b2) {
                        this.binCounts(chr, seg.getStart(), seg.getEnd(), segScore, b2, this.binSize);
                    }
                    if (!wgChromosomes.contains(chr)) continue;
                    int gStart = this.genome.getGenomeCoordinate(chr, seg.getStart());
                    int gEnd = this.genome.getGenomeCoordinate(chr, seg.getEnd());
                    int wgStartBin = gStart / wgBinSize;
                    int wgEndBin = gEnd / wgBinSize;
                    for (int b3 = wgStartBin; b3 <= wgEndBin && b3 < this.amp.get("All").size(); ++b3) {
                        this.binCounts("All", gStart, gEnd, segScore, b3, wgBinSize);
                    }
                }
            }
        }
    }

    private void binCounts(String chr, int segStart, int segEnd, float segScore, int b2, int binSize) {
        int binStart = b2 * binSize;
        int binEnd = binStart + binSize;
        float weight = 1.0f;
        if (segEnd < binEnd) {
            int s2 = Math.max(segStart, binStart);
            weight = (float)(segEnd - s2) / (float)binSize;
        } else if (segStart > binStart) {
            int e2 = Math.min(segEnd, binEnd);
            weight = (float)(e2 - segStart) / (float)binSize;
        }
        if (segScore > this.ampThreshold) {
            Bin bin = (Bin)this.amp.get(chr).get(b2);
            bin.increment(weight, weight * segScore);
        }
        if (segScore < this.delThreshold) {
            Bin bin = (Bin)this.del.get(chr).get(b2);
            bin.increment(-weight, weight * segScore);
        }
    }

    public void dumpData(String chr) {
        System.out.println("track name=Amplifications");
        for (Map.Entry<String, List<LocusScore>> entry : this.amp.entrySet()) {
            if (entry.getKey().equals("All")) continue;
            for (LocusScore bin : entry.getValue()) {
                System.out.println(bin.getChr() + "\t" + bin.getStart() + "\t" + bin.getEnd() + "\t" + bin.getScore());
            }
        }
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public List<LocusScore> getAmpCounts(String chr) {
        return this.amp.get(chr);
    }

    public List<LocusScore> getDelCounts(String chr) {
        return this.del.get(chr);
    }

    public float getAmpThreshold() {
        return this.ampThreshold;
    }

    public float getDelThreshold() {
        return this.delThreshold;
    }

    public class Bin
    implements LocusScore {
        String chr;
        int start;
        int end;
        float count;
        private float totalCN;

        Bin(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        void increment(float count, float score) {
            this.count += count;
            this.totalCN = this.getTotalCN() + score;
        }

        float getCount() {
            return this.count;
        }

        float getAvgCN() {
            return this.count == 0.0f ? 0.0f : this.getTotalCN() / this.count;
        }

        @Override
        public String getChr() {
            return this.chr;
        }

        @Override
        public String getContig() {
            return this.chr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public void setStart(int start) {
        }

        @Override
        public void setEnd(int end) {
        }

        @Override
        public float getScore() {
            return this.getCount();
        }

        public LocusScore copy() {
            return this;
        }

        @Override
        public String getValueString(double position, WindowFunction windowFunction) {
            int cnt = Math.abs(Math.round(this.count));
            int percent = cnt * 100 / FreqData.this.numberOfSamples;
            return cnt + " (" + percent + "%)";
        }

        public float getTotalCN() {
            return this.totalCN;
        }
    }
}

