/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Max
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -5593383832225844641L;
    private long n;
    private double value;

    public Max() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Max(Max original) {
        Max.copy(original, this);
    }

    public void increment(double d2) {
        if (d2 > this.value || Double.isNaN(this.value)) {
            this.value = d2;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] values, int begin, int length) {
        double max = Double.NaN;
        if (this.test(values, begin, length)) {
            max = values[begin];
            for (int i2 = begin; i2 < begin + length; ++i2) {
                if (Double.isNaN(values[i2])) continue;
                max = max > values[i2] ? max : values[i2];
            }
        }
        return max;
    }

    public Max copy() {
        Max result = new Max();
        Max.copy(this, result);
        return result;
    }

    public static void copy(Max source, Max dest) {
        dest.setData(source.getDataRef());
        dest.n = source.n;
        dest.value = source.value;
    }
}

