/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.correlation;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.stat.correlation.Covariance;
import org.apache.commons.math.stat.regression.SimpleRegression;
import org.apache.commons.math.util.FastMath;

public class PearsonsCorrelation {
    private final RealMatrix correlationMatrix;
    private final int nObs;

    public PearsonsCorrelation() {
        this.correlationMatrix = null;
        this.nObs = 0;
    }

    public PearsonsCorrelation(double[][] data) {
        this(new BlockRealMatrix(data));
    }

    public PearsonsCorrelation(RealMatrix matrix) {
        this.checkSufficientData(matrix);
        this.nObs = matrix.getRowDimension();
        this.correlationMatrix = this.computeCorrelationMatrix(matrix);
    }

    public PearsonsCorrelation(Covariance covariance) {
        RealMatrix covarianceMatrix = covariance.getCovarianceMatrix();
        if (covarianceMatrix == null) {
            throw new NullArgumentException(LocalizedFormats.COVARIANCE_MATRIX);
        }
        this.nObs = covariance.getN();
        this.correlationMatrix = this.covarianceToCorrelation(covarianceMatrix);
    }

    public PearsonsCorrelation(RealMatrix covarianceMatrix, int numberOfObservations) {
        this.nObs = numberOfObservations;
        this.correlationMatrix = this.covarianceToCorrelation(covarianceMatrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix getCorrelationStandardErrors() {
        int nVars = this.correlationMatrix.getColumnDimension();
        double[][] out = new double[nVars][nVars];
        for (int i2 = 0; i2 < nVars; ++i2) {
            for (int j2 = 0; j2 < nVars; ++j2) {
                double r2 = this.correlationMatrix.getEntry(i2, j2);
                out[i2][j2] = FastMath.sqrt((1.0 - r2 * r2) / (double)(this.nObs - 2));
            }
        }
        return new BlockRealMatrix(out);
    }

    public RealMatrix getCorrelationPValues() throws MathException {
        TDistributionImpl tDistribution = new TDistributionImpl(this.nObs - 2);
        int nVars = this.correlationMatrix.getColumnDimension();
        double[][] out = new double[nVars][nVars];
        for (int i2 = 0; i2 < nVars; ++i2) {
            for (int j2 = 0; j2 < nVars; ++j2) {
                if (i2 == j2) {
                    out[i2][j2] = 0.0;
                    continue;
                }
                double r2 = this.correlationMatrix.getEntry(i2, j2);
                double t2 = FastMath.abs(r2 * FastMath.sqrt((double)(this.nObs - 2) / (1.0 - r2 * r2)));
                out[i2][j2] = 2.0 * tDistribution.cumulativeProbability(-t2);
            }
        }
        return new BlockRealMatrix(out);
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix matrix) {
        int nVars = matrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(nVars, nVars);
        for (int i2 = 0; i2 < nVars; ++i2) {
            for (int j2 = 0; j2 < i2; ++j2) {
                double corr = this.correlation(matrix.getColumn(i2), matrix.getColumn(j2));
                outMatrix.setEntry(i2, j2, corr);
                outMatrix.setEntry(j2, i2, corr);
            }
            outMatrix.setEntry(i2, i2, 1.0);
        }
        return outMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] data) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(data));
    }

    public double correlation(double[] xArray, double[] yArray) throws IllegalArgumentException {
        SimpleRegression regression = new SimpleRegression();
        if (xArray.length != yArray.length) {
            throw new DimensionMismatchException(xArray.length, yArray.length);
        }
        if (xArray.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, xArray.length, 2);
        }
        for (int i2 = 0; i2 < xArray.length; ++i2) {
            regression.addData(xArray[i2], yArray[i2]);
        }
        return regression.getR();
    }

    public RealMatrix covarianceToCorrelation(RealMatrix covarianceMatrix) {
        int nVars = covarianceMatrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(nVars, nVars);
        for (int i2 = 0; i2 < nVars; ++i2) {
            double sigma = FastMath.sqrt(covarianceMatrix.getEntry(i2, i2));
            outMatrix.setEntry(i2, i2, 1.0);
            for (int j2 = 0; j2 < i2; ++j2) {
                double entry = covarianceMatrix.getEntry(i2, j2) / (sigma * FastMath.sqrt(covarianceMatrix.getEntry(j2, j2)));
                outMatrix.setEntry(i2, j2, entry);
                outMatrix.setEntry(j2, i2, entry);
            }
        }
        return outMatrix;
    }

    private void checkSufficientData(RealMatrix matrix) {
        int nRows = matrix.getRowDimension();
        int nCols = matrix.getColumnDimension();
        if (nRows < 2 || nCols < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, nRows, nCols);
        }
    }
}

