/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BetaDistributionImpl;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.distribution.CauchyDistributionImpl;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.distribution.HypergeometricDistributionImpl;
import org.apache.commons.math.distribution.IntegerDistribution;
import org.apache.commons.math.distribution.PascalDistributionImpl;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.distribution.WeibullDistributionImpl;
import org.apache.commons.math.distribution.ZipfDistributionImpl;
import org.apache.commons.math.exception.MathInternalError;
import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.exception.NumberIsTooLargeException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    @Override
    public String nextHexString(int len) {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        RandomGenerator ran = this.getRan();
        StringBuilder outBuffer = new StringBuilder();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i2 = 0; i2 < randomBytes.length; ++i2) {
            Integer c2 = randomBytes[i2];
            String hex = Integer.toHexString(c2 + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        double r2 = this.getRan().nextDouble();
        return (int)(r2 * (double)upper + (1.0 - r2) * (double)lower + r2);
    }

    @Override
    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        double r2 = this.getRan().nextDouble();
        return (long)(r2 * (double)upper + (1.0 - r2) * (double)lower + r2);
    }

    @Override
    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new MathInternalError(ex);
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuilder outBuffer = new StringBuilder();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i2 = 0; i2 < hash.length; ++i2) {
                Integer c2 = hash[i2];
                String hex = Integer.toHexString(c2 + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (int)(sec.nextDouble() * (double)(upper - lower + 1));
    }

    @Override
    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (long)(sec.nextDouble() * (double)(upper - lower + 1L));
    }

    @Override
    public long nextPoisson(double mean) {
        double y;
        long y2;
        block10: {
            if (mean <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, mean);
            }
            RandomGenerator generator = this.getRan();
            double pivot = 40.0;
            if (mean < 40.0) {
                double p2 = FastMath.exp(-mean);
                long n2 = 0L;
                double r2 = 1.0;
                double rnd = 1.0;
                while ((double)n2 < 1000.0 * mean) {
                    rnd = generator.nextDouble();
                    if ((r2 *= rnd) >= p2) {
                        ++n2;
                        continue;
                    }
                    return n2;
                }
                return n2;
            }
            double lambda = FastMath.floor(mean);
            double lambdaFractional = mean - lambda;
            double logLambda = FastMath.log(lambda);
            double logLambdaFactorial = MathUtils.factorialLog((int)lambda);
            y2 = lambdaFractional < Double.MIN_VALUE ? 0L : this.nextPoisson(lambdaFractional);
            double delta = FastMath.sqrt(lambda * FastMath.log(32.0 * lambda / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda + delta;
            double a1 = FastMath.sqrt(Math.PI * twolpd) * FastMath.exp(0.0 * lambda);
            double a2 = twolpd / delta * FastMath.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda);
            double x2 = 0.0;
            y = 0.0;
            double v2 = 0.0;
            boolean a3 = false;
            double t2 = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u2;
                if ((u2 = this.nextUniform(0.0, 1.0)) <= p1) {
                    double n3 = this.nextGaussian(0.0, 1.0);
                    x2 = n3 * FastMath.sqrt(lambda + halfDelta) - 0.5;
                    if (x2 > delta || x2 < -lambda) continue;
                    y = x2 < 0.0 ? FastMath.floor(x2) : FastMath.ceil(x2);
                    double e2 = this.nextExponential(1.0);
                    v2 = -e2 - n3 * n3 / 2.0 + c1;
                } else {
                    if (u2 > p1 + p2) {
                        y = lambda;
                        break block10;
                    }
                    x2 = delta + twolpd / delta * this.nextExponential(1.0);
                    y = FastMath.ceil(x2);
                    v2 = -this.nextExponential(1.0) - delta * (x2 + 1.0) / twolpd;
                }
                a3 = x2 < 0.0;
                t2 = y * (y + 1.0) / (2.0 * lambda);
                if (v2 < -t2 && !a3) {
                    y = lambda + y;
                    break block10;
                }
                qr = t2 * ((2.0 * y + 1.0) / (6.0 * lambda) - 1.0);
                qa = qr - t2 * t2 / (3.0 * (lambda + (double)a3 * (y + 1.0)));
                if (v2 < qa) {
                    y = lambda + y;
                    break block10;
                }
                if (!(v2 > qr) && v2 < y * logLambda - MathUtils.factorialLog((int)(y + lambda)) + logLambdaFactorial) break;
            }
            y = lambda + y;
        }
        return y2 + (long)y;
    }

    @Override
    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, sigma);
        }
        return sigma * this.getRan().nextGaussian() + mu;
    }

    @Override
    public double nextExponential(double mean) {
        if (mean <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, mean);
        }
        RandomGenerator generator = this.getRan();
        double unif = generator.nextDouble();
        while (unif == 0.0) {
            unif = generator.nextDouble();
        }
        return -mean * FastMath.log(unif);
    }

    @Override
    public double nextUniform(double lower, double upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        RandomGenerator generator = this.getRan();
        double u2 = generator.nextDouble();
        while (u2 <= 0.0) {
            u2 = generator.nextDouble();
        }
        return lower + u2 * (upper - lower);
    }

    public double nextBeta(double alpha, double beta) throws MathException {
        return this.nextInversionDeviate(new BetaDistributionImpl(alpha, beta));
    }

    public int nextBinomial(int numberOfTrials, double probabilityOfSuccess) throws MathException {
        return this.nextInversionDeviate(new BinomialDistributionImpl(numberOfTrials, probabilityOfSuccess));
    }

    public double nextCauchy(double median, double scale) throws MathException {
        return this.nextInversionDeviate(new CauchyDistributionImpl(median, scale));
    }

    public double nextChiSquare(double df) throws MathException {
        return this.nextInversionDeviate(new ChiSquaredDistributionImpl(df));
    }

    public double nextF(double numeratorDf, double denominatorDf) throws MathException {
        return this.nextInversionDeviate(new FDistributionImpl(numeratorDf, denominatorDf));
    }

    public double nextGamma(double shape, double scale) throws MathException {
        return this.nextInversionDeviate(new GammaDistributionImpl(shape, scale));
    }

    public int nextHypergeometric(int populationSize, int numberOfSuccesses, int sampleSize) throws MathException {
        return this.nextInversionDeviate(new HypergeometricDistributionImpl(populationSize, numberOfSuccesses, sampleSize));
    }

    public int nextPascal(int r2, double p2) throws MathException {
        return this.nextInversionDeviate(new PascalDistributionImpl(r2, p2));
    }

    public double nextT(double df) throws MathException {
        return this.nextInversionDeviate(new TDistributionImpl(df));
    }

    public double nextWeibull(double shape, double scale) throws MathException {
        return this.nextInversionDeviate(new WeibullDistributionImpl(shape, scale));
    }

    public int nextZipf(int numberOfElements, double exponent) throws MathException {
        return this.nextInversionDeviate(new ZipfDistributionImpl(numberOfElements, exponent));
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
            this.rand.setSeed(System.currentTimeMillis());
        }
        return this.rand;
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis());
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(System.currentTimeMillis());
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    @Override
    public int[] nextPermutation(int n2, int k2) {
        if (k2 > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)k2, (Number)n2, true);
        }
        if (k2 == 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, k2);
        }
        int[] index = this.getNatural(n2);
        this.shuffle(index, n2 - k2);
        int[] result = new int[k2];
        for (int i2 = 0; i2 < k2; ++i2) {
            result[i2] = index[n2 - i2 - 1];
        }
        return result;
    }

    @Override
    public Object[] nextSample(Collection<?> c2, int k2) {
        int len = c2.size();
        if (k2 > len) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)k2, (Number)len, true);
        }
        if (k2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, k2);
        }
        Object[] objects = c2.toArray();
        int[] index = this.nextPermutation(len, k2);
        Object[] result = new Object[k2];
        for (int i2 = 0; i2 < k2; ++i2) {
            result[i2] = objects[index[i2]];
        }
        return result;
    }

    public double nextInversionDeviate(ContinuousDistribution distribution) throws MathException {
        return distribution.inverseCumulativeProbability(this.nextUniform(0.0, 1.0));
    }

    public int nextInversionDeviate(IntegerDistribution distribution) throws MathException {
        double target = this.nextUniform(0.0, 1.0);
        int glb = distribution.inverseCumulativeProbability(target);
        if (distribution.cumulativeProbability(glb) == 1.0) {
            return glb;
        }
        return glb + 1;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i2 = list.length - 1; i2 >= end; --i2) {
            target = i2 == 0 ? 0 : this.nextInt(0, i2);
            int temp = list[target];
            list[target] = list[i2];
            list[i2] = temp;
        }
    }

    private int[] getNatural(int n2) {
        int[] natural = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            natural[i2] = i2;
        }
        return natural;
    }
}

