/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.univariate;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.univariate.AbstractUnivariateRealOptimizer;
import org.apache.commons.math.util.FastMath;

public class BrentOptimizer
extends AbstractUnivariateRealOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));

    public BrentOptimizer() {
        this.setMaxEvaluations(1000);
        this.setMaximalIterationCount(100);
        this.setAbsoluteAccuracy(1.0E-11);
        this.setRelativeAccuracy(1.0E-9);
    }

    protected double doOptimize() throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.localMin(this.getGoalType() == GoalType.MINIMIZE, this.getMin(), this.getStartValue(), this.getMax(), this.getRelativeAccuracy(), this.getAbsoluteAccuracy());
    }

    private double localMin(boolean isMinim, double lo, double mid, double hi, double eps, double t2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x2;
        double b2;
        double a2;
        if (eps <= 0.0) {
            throw new NotStrictlyPositiveException(eps);
        }
        if (t2 <= 0.0) {
            throw new NotStrictlyPositiveException(t2);
        }
        if (lo < hi) {
            a2 = lo;
            b2 = hi;
        } else {
            a2 = hi;
            b2 = lo;
        }
        double v2 = x2 = mid;
        double w2 = x2;
        double d2 = 0.0;
        double e2 = 0.0;
        double fx = this.computeObjectiveValue(x2);
        if (!isMinim) {
            fx = -fx;
        }
        double fv = fx;
        double fw = fx;
        while (true) {
            double m2 = 0.5 * (a2 + b2);
            double tol1 = eps * FastMath.abs(x2) + t2;
            double tol2 = 2.0 * tol1;
            if (FastMath.abs(x2 - m2) > tol2 - 0.5 * (b2 - a2)) {
                double p2 = 0.0;
                double q2 = 0.0;
                double r2 = 0.0;
                double u2 = 0.0;
                if (FastMath.abs(e2) > tol1) {
                    r2 = (x2 - w2) * (fx - fv);
                    q2 = (x2 - v2) * (fx - fw);
                    p2 = (x2 - v2) * q2 - (x2 - w2) * r2;
                    if ((q2 = 2.0 * (q2 - r2)) > 0.0) {
                        p2 = -p2;
                    } else {
                        q2 = -q2;
                    }
                    r2 = e2;
                    e2 = d2;
                    if (p2 > q2 * (a2 - x2) && p2 < q2 * (b2 - x2) && FastMath.abs(p2) < FastMath.abs(0.5 * q2 * r2)) {
                        d2 = p2 / q2;
                        u2 = x2 + d2;
                        if (u2 - a2 < tol2 || b2 - u2 < tol2) {
                            d2 = x2 <= m2 ? tol1 : -tol1;
                        }
                    } else {
                        e2 = x2 < m2 ? b2 - x2 : a2 - x2;
                        d2 = GOLDEN_SECTION * e2;
                    }
                } else {
                    e2 = x2 < m2 ? b2 - x2 : a2 - x2;
                    d2 = GOLDEN_SECTION * e2;
                }
                u2 = FastMath.abs(d2) < tol1 ? (d2 >= 0.0 ? x2 + tol1 : x2 - tol1) : x2 + d2;
                double fu = this.computeObjectiveValue(u2);
                if (!isMinim) {
                    fu = -fu;
                }
                if (fu <= fx) {
                    if (u2 < x2) {
                        b2 = x2;
                    } else {
                        a2 = x2;
                    }
                    v2 = w2;
                    fv = fw;
                    w2 = x2;
                    fw = fx;
                    x2 = u2;
                    fx = fu;
                } else {
                    if (u2 < x2) {
                        a2 = u2;
                    } else {
                        b2 = u2;
                    }
                    if (fu <= fw || w2 == x2) {
                        v2 = w2;
                        fv = fw;
                        w2 = u2;
                        fw = fu;
                    } else if (fu <= fv || v2 == x2 || v2 == w2) {
                        v2 = u2;
                        fv = fu;
                    }
                }
            } else {
                this.setFunctionValue(isMinim ? fx : -fx);
                return x2;
            }
            this.incrementIterationsCounter();
        }
    }
}

