/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;

public class Main {
    public static void main(String[] args) throws Exception {
        JexlEngine engine = new JexlEngine();
        MapContext context = new MapContext();
        context.set("args", args);
        if (args.length == 1) {
            Script script = engine.createScript(new File(args[0]));
            Object value = script.execute(context);
            System.out.println("Return value: " + value);
        } else {
            String line;
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> ");
            while (null != (line = console.readLine())) {
                try {
                    Expression expression = engine.createExpression(line);
                    Object value = expression.evaluate(context);
                    System.out.println("Return value: " + value);
                }
                catch (JexlException e2) {
                    System.out.println(e2.getLocalizedMessage());
                }
                System.out.print("> ");
            }
        }
    }
}

