/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGGlyphElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    protected SVGGlyphElementBridge() {
    }

    public String getLocalName() {
        return "glyph";
    }

    public Glyph createGlyph(BridgeContext ctx, Element glyphElement, Element textElement, int glyphCode, float fontSize, GVTFontFace fontFace, TextPaintInfo tpi) {
        float horizOriginY;
        float horizOriginX;
        float vertOriginY;
        float vertOriginX;
        float vertAdvY;
        float horizAdvX;
        float fontHeight = fontFace.getUnitsPerEm();
        float scale = fontSize / fontHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scale, -scale);
        String d2 = glyphElement.getAttributeNS(null, "d");
        Shape dShape = null;
        if (d2.length() != 0) {
            AWTPathProducer app = new AWTPathProducer();
            app.setWindingRule(CSSUtilities.convertFillRule(textElement));
            try {
                Shape transformedShape;
                try {
                    PathParser pathParser = new PathParser();
                    pathParser.setPathHandler(app);
                    pathParser.parse(d2);
                }
                catch (ParseException pEx) {
                    throw new BridgeException(ctx, glyphElement, pEx, "attribute.malformed", new Object[]{"d"});
                }
                Object var16_17 = null;
                Shape shape = app.getShape();
                dShape = transformedShape = scaleTransform.createTransformedShape(shape);
            }
            catch (Throwable throwable) {
                Shape transformedShape;
                Object var16_18 = null;
                Shape shape = app.getShape();
                dShape = transformedShape = scaleTransform.createTransformedShape(shape);
                throw throwable;
            }
        }
        NodeList glyphChildren = glyphElement.getChildNodes();
        int numChildren = glyphChildren.getLength();
        int numGlyphChildren = 0;
        int i2 = 0;
        while (i2 < numChildren) {
            Node childNode = glyphChildren.item(i2);
            if (childNode.getNodeType() == 1) {
                ++numGlyphChildren;
            }
            ++i2;
        }
        CompositeGraphicsNode glyphContentNode = null;
        if (numGlyphChildren > 0) {
            GVTBuilder builder = ctx.getGVTBuilder();
            glyphContentNode = new CompositeGraphicsNode();
            Element fontElementClone = (Element)glyphElement.getParentNode().cloneNode(false);
            NamedNodeMap fontAttributes = glyphElement.getParentNode().getAttributes();
            int numAttributes = fontAttributes.getLength();
            int i3 = 0;
            while (i3 < numAttributes) {
                fontElementClone.setAttributeNode((Attr)fontAttributes.item(i3));
                ++i3;
            }
            Element clonedGlyphElement = (Element)glyphElement.cloneNode(true);
            fontElementClone.appendChild(clonedGlyphElement);
            textElement.appendChild(fontElementClone);
            CompositeGraphicsNode glyphChildrenNode = new CompositeGraphicsNode();
            glyphChildrenNode.setTransform(scaleTransform);
            NodeList clonedGlyphChildren = clonedGlyphElement.getChildNodes();
            int numClonedChildren = clonedGlyphChildren.getLength();
            int i4 = 0;
            while (i4 < numClonedChildren) {
                Node childNode = clonedGlyphChildren.item(i4);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    GraphicsNode childGraphicsNode = builder.build(ctx, childElement);
                    glyphChildrenNode.add(childGraphicsNode);
                }
                ++i4;
            }
            glyphContentNode.add(glyphChildrenNode);
            textElement.removeChild(fontElementClone);
        }
        String unicode = glyphElement.getAttributeNS(null, "unicode");
        String nameList2 = glyphElement.getAttributeNS(null, "glyph-name");
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(nameList2, " ,");
        while (st.hasMoreTokens()) {
            names.add(st.nextToken());
        }
        String orientation = glyphElement.getAttributeNS(null, "orientation");
        String arabicForm = glyphElement.getAttributeNS(null, "arabic-form");
        String lang = glyphElement.getAttributeNS(null, "lang");
        Element parentFontElement = (Element)glyphElement.getParentNode();
        String s2 = glyphElement.getAttributeNS(null, "horiz-adv-x");
        if (s2.length() == 0 && (s2 = parentFontElement.getAttributeNS(null, "horiz-adv-x")).length() == 0) {
            throw new BridgeException(ctx, parentFontElement, "attribute.missing", new Object[]{"horiz-adv-x"});
        }
        try {
            horizAdvX = SVGUtilities.convertSVGNumber(s2) * scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, glyphElement, nfEx, "attribute.malformed", new Object[]{"horiz-adv-x", s2});
        }
        s2 = glyphElement.getAttributeNS(null, "vert-adv-y");
        if (s2.length() == 0 && (s2 = parentFontElement.getAttributeNS(null, "vert-adv-y")).length() == 0) {
            s2 = String.valueOf(fontFace.getUnitsPerEm());
        }
        try {
            vertAdvY = SVGUtilities.convertSVGNumber(s2) * scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, glyphElement, nfEx, "attribute.malformed", new Object[]{"vert-adv-y", s2});
        }
        s2 = glyphElement.getAttributeNS(null, "vert-origin-x");
        if (s2.length() == 0 && (s2 = parentFontElement.getAttributeNS(null, "vert-origin-x")).length() == 0) {
            s2 = Float.toString(horizAdvX / 2.0f);
        }
        try {
            vertOriginX = SVGUtilities.convertSVGNumber(s2) * scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, glyphElement, nfEx, "attribute.malformed", new Object[]{"vert-origin-x", s2});
        }
        s2 = glyphElement.getAttributeNS(null, "vert-origin-y");
        if (s2.length() == 0 && (s2 = parentFontElement.getAttributeNS(null, "vert-origin-y")).length() == 0) {
            s2 = String.valueOf(fontFace.getAscent());
        }
        try {
            vertOriginY = SVGUtilities.convertSVGNumber(s2) * -scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, glyphElement, nfEx, "attribute.malformed", new Object[]{"vert-origin-y", s2});
        }
        Point2D.Float vertOrigin = new Point2D.Float(vertOriginX, vertOriginY);
        s2 = parentFontElement.getAttributeNS(null, "horiz-origin-x");
        if (s2.length() == 0) {
            s2 = "0";
        }
        try {
            horizOriginX = SVGUtilities.convertSVGNumber(s2) * scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, parentFontElement, nfEx, "attribute.malformed", new Object[]{"horiz-origin-x", s2});
        }
        s2 = parentFontElement.getAttributeNS(null, "horiz-origin-y");
        if (s2.length() == 0) {
            s2 = "0";
        }
        try {
            horizOriginY = SVGUtilities.convertSVGNumber(s2) * -scale;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, glyphElement, nfEx, "attribute.malformed", new Object[]{"horiz-origin-y", s2});
        }
        Point2D.Float horizOrigin = new Point2D.Float(horizOriginX, horizOriginY);
        return new Glyph(unicode, names, orientation, arabicForm, lang, horizOrigin, vertOrigin, horizAdvX, vertAdvY, glyphCode, tpi, dShape, glyphContentNode);
    }
}

