/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.LinkedList;

public class CramRecordReader
extends AbstractReader {
    private CramCompressionRecord prevRecord;

    public void read(CramCompressionRecord cramRecord) {
        try {
            int i2;
            cramRecord.flags = (Integer)this.bitFlagsCodec.readData();
            cramRecord.compressionFlags = ((Byte)this.compressionBitFlagsCodec.readData()).byteValue();
            cramRecord.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            cramRecord.readLength = (Integer)this.readLengthCodec.readData();
            if (this.APDelta) {
                cramRecord.alignmentDelta = (Integer)this.alignmentStartCodec.readData();
            } else {
                cramRecord.alignmentStart = (Integer)this.alignmentStartCodec.readData();
            }
            cramRecord.readGroupID = (Integer)this.readGroupCodec.readData();
            if (this.captureReadNames) {
                cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
            }
            if (cramRecord.isDetached()) {
                cramRecord.mateFlags = ((Byte)this.mateBitFlagCodec.readData()).byteValue();
                if (!this.captureReadNames) {
                    cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
                }
                cramRecord.mateSequenceID = (Integer)this.mateReferenceIdCodec.readData();
                cramRecord.mateAlignmentStart = (Integer)this.mateAlignmentStartCodec.readData();
                cramRecord.templateSize = (Integer)this.insertSizeCodec.readData();
                ++detachedCount;
            } else if (cramRecord.isHasMateDownStream()) {
                cramRecord.recordsToNextFragment = (Integer)this.distanceToNextFragmentCodec.readData();
            }
            Integer tagIdList = (Integer)this.tagIdListCodec.readData();
            byte[][] ids = this.tagIdDictionary[tagIdList];
            if (ids.length > 0) {
                int tagCount = ids.length;
                cramRecord.tags = new ReadTag[tagCount];
                for (i2 = 0; i2 < ids.length; ++i2) {
                    ReadTag tag;
                    int id = ReadTag.name3BytesToInt(ids[i2]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(id);
                    cramRecord.tags[i2] = tag = new ReadTag(id, (byte[])dataReader.readData());
                }
            }
            if (!cramRecord.isSegmentUnmapped()) {
                int size = (Integer)this.numberOfReadFeaturesCodec.readData();
                int prevPos = 0;
                LinkedList<ReadFeature> readFeatures = new LinkedList<ReadFeature>();
                cramRecord.readFeatures = readFeatures;
                block17: for (int i3 = 0; i3 < size; ++i3) {
                    int pos;
                    Byte operator = (Byte)this.readFeatureCodeCodec.readData();
                    prevPos = pos = prevPos + (Integer)this.readFeaturePositionCodec.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase readBase = new ReadBase(pos, (Byte)this.baseCodec.readData(), (Byte)this.qualityScoreCodec.readData());
                            readFeatures.add(readBase);
                            continue block17;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(pos);
                            byte code = (Byte)this.baseSubstitutionCodec.readData();
                            substitution.setCode(code);
                            readFeatures.add(substitution);
                            continue block17;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(pos, (byte[])this.insertionCodec.readData());
                            readFeatures.add(insertion);
                            continue block17;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(pos, (byte[])this.softClipCodec.readData());
                            readFeatures.add(softClip);
                            continue block17;
                        }
                        case 72: {
                            HardClip hardCLip = new HardClip(pos, (Integer)this.hardClipCodec.readData());
                            readFeatures.add(hardCLip);
                            continue block17;
                        }
                        case 80: {
                            Padding padding = new Padding(pos, (Integer)this.paddingCodec.readData());
                            readFeatures.add(padding);
                            continue block17;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(pos, (Integer)this.deletionLengthCodec.readData());
                            readFeatures.add(deletion);
                            continue block17;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(pos, (Integer)this.refSkipCodec.readData());
                            readFeatures.add(refSkip);
                            continue block17;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(pos, (Byte)this.baseCodec.readData());
                            readFeatures.add(insertBase);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(pos, (Byte)this.qualityScoreCodec.readData());
                            readFeatures.add(baseQualityScore);
                            continue block17;
                        }
                        case 98: {
                            Bases bases = new Bases(pos, (byte[])this.basesCodec.readData());
                            readFeatures.add(bases);
                            continue block17;
                        }
                        case 113: {
                            Scores scores = new Scores(pos, (byte[])this.scoresCodec.readData());
                            readFeatures.add(scores);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                }
                cramRecord.mappingQuality = (Integer)this.mappingScoreCodec.readData();
                if (cramRecord.isForcePreserveQualityScores()) {
                    cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(cramRecord.readLength);
                }
            } else if (cramRecord.isUnknownBases()) {
                cramRecord.readBases = SAMRecord.NULL_SEQUENCE;
                cramRecord.qualityScores = SAMRecord.NULL_QUALS;
            } else {
                byte[] bases = new byte[cramRecord.readLength];
                for (i2 = 0; i2 < bases.length; ++i2) {
                    bases[i2] = (Byte)this.baseCodec.readData();
                }
                cramRecord.readBases = bases;
                if (cramRecord.isForcePreserveQualityScores()) {
                    cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(cramRecord.readLength);
                }
            }
            ++this.recordCounter;
            this.prevRecord = cramRecord;
        }
        catch (Exception e2) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeException(e2);
        }
    }
}

