/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord firstEnd, SAMRecord secondEnd) throws SanityCheckFailedException {
        SAMTestUtil.assertEquals(firstEnd.getReadName(), secondEnd.getReadName());
        SAMTestUtil.assertTrue(firstEnd.getFirstOfPairFlag());
        SAMTestUtil.assertTrue(secondEnd.getSecondOfPairFlag());
        SAMTestUtil.assertFalse(secondEnd.getFirstOfPairFlag());
        SAMTestUtil.assertFalse(firstEnd.getSecondOfPairFlag());
        if (!firstEnd.getReadUnmappedFlag() && !secondEnd.getReadUnmappedFlag()) {
            SAMTestUtil.assertNotSame(firstEnd.getReadNegativeStrandFlag(), secondEnd.getReadNegativeStrandFlag());
        }
    }

    public void assertReadValid(SAMRecord read) throws SanityCheckFailedException {
        SAMTestUtil.assertEquals(read.getReadBases().length, read.getBaseQualities().length);
        if (read.getReferenceName().equals("*")) {
            SAMTestUtil.assertEquals(read.getAlignmentStart(), 0);
            SAMTestUtil.assertTrue(read.getReadUnmappedFlag());
        } else {
            SAMTestUtil.assertNotSame(read.getAlignmentStart(), 0);
        }
        if (read.getReadUnmappedFlag()) {
            SAMTestUtil.assertEquals(read.getMappingQuality(), 0);
            SAMTestUtil.assertEquals(read.getCigar().getCigarElements().size(), 0);
        } else {
            SAMTestUtil.assertNotSame(read.getCigar().getCigarElements(), 0);
        }
        if (read.getReadPairedFlag()) {
            if (read.getMateReferenceName().equals("*")) {
                SAMTestUtil.assertEquals(read.getMateAlignmentStart(), 0);
                SAMTestUtil.assertTrue(read.getMateUnmappedFlag());
            } else {
                SAMTestUtil.assertNotSame(read.getMateAlignmentStart(), 0);
            }
            if (read.getReadUnmappedFlag() || read.getMateUnmappedFlag() || !read.getReferenceName().equals(read.getMateReferenceName())) {
                SAMTestUtil.assertEquals(read.getInferredInsertSize(), 0);
            } else {
                SAMTestUtil.assertNotSame(read.getInferredInsertSize(), 0);
            }
            if (!read.getReadUnmappedFlag() && !read.getMateUnmappedFlag()) {
                SAMTestUtil.assertNotSame(read.getReadNegativeStrandFlag(), read.getMateNegativeStrandFlag());
                SAMTestUtil.assertNotSame(read.getMateNegativeStrandFlag(), read.getReadName());
            }
        } else {
            SAMTestUtil.assertEquals(read.getInferredInsertSize(), 0);
        }
    }

    private static <T> void assertEquals(T a2, T b2) {
        if (a2 == null ? b2 != null : !a2.equals(b2)) {
            throw new SanityCheckFailedException("\"" + a2 + "\" does not equal \"" + b2 + "\"");
        }
    }

    private static <T> void assertNotSame(T a2, T b2) {
        if (a2 != b2) {
            throw new SanityCheckFailedException("\"" + a2 + "\" and \"" + b2 + "\" are not the same object");
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new SanityCheckFailedException("The condition is false");
        }
    }

    private static void assertFalse(boolean condition) {
        if (condition) {
            throw new SanityCheckFailedException("The condition is true");
        }
    }

    public static class SanityCheckFailedException
    extends RuntimeException {
        public SanityCheckFailedException(String message) {
            super(message);
        }
    }
}

