/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.Log;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomReaderFactory {
    private static final Log LOG = Log.getInstance(CustomReaderFactory.class);
    private static final CustomReaderFactory DEFAULT_FACTORY;
    private static CustomReaderFactory currentFactory;
    private String urlPrefix = "";
    private String factoryClassName = "";
    private String jarFile = "";
    private ICustomReaderFactory factory;

    public static void setInstance(CustomReaderFactory factory) {
        currentFactory = factory;
    }

    public static void resetToDefaultInstance() {
        CustomReaderFactory.setInstance(DEFAULT_FACTORY);
    }

    public static CustomReaderFactory getInstance() {
        return currentFactory;
    }

    private CustomReaderFactory() {
        this(Defaults.CUSTOM_READER_FACTORY);
    }

    CustomReaderFactory(String cfg) {
        String[] cfgComponents = cfg.split(",");
        if (cfgComponents.length < 2) {
            return;
        }
        this.urlPrefix = cfgComponents[0].toLowerCase();
        this.factoryClassName = cfgComponents[1];
        if (cfgComponents.length > 2) {
            this.jarFile = cfgComponents[2];
        }
    }

    private synchronized ICustomReaderFactory getFactory() {
        if (this.factory == null) {
            try {
                Class<?> clazz = null;
                if (!this.jarFile.isEmpty()) {
                    LOG.info("Attempting to load factory class " + this.factoryClassName + " from " + this.jarFile);
                    URL jarURL = new URL("file:///" + this.jarFile);
                    clazz = Class.forName(this.factoryClassName, true, new URLClassLoader(new URL[]{jarURL}, this.getClass().getClassLoader()));
                } else {
                    LOG.info("Attempting to load factory class " + this.factoryClassName);
                    clazz = Class.forName(this.factoryClassName);
                }
                this.factory = (ICustomReaderFactory)clazz.newInstance();
                LOG.info("Created custom factory for " + this.urlPrefix + " from " + this.factoryClassName + " loaded from " + (this.jarFile.isEmpty() ? " this jar" : this.jarFile));
            }
            catch (Exception e2) {
                LOG.error(e2, new Object[0]);
                return null;
            }
        }
        return this.factory;
    }

    public SamReader maybeOpen(URL url) {
        if (this.urlPrefix.isEmpty() || !url.toString().toLowerCase().startsWith(this.urlPrefix)) {
            return null;
        }
        LOG.info("Attempting to open " + url + " with custom factory");
        ICustomReaderFactory factory = this.getFactory();
        if (factory == null) {
            return null;
        }
        return factory.open(url);
    }

    static {
        currentFactory = DEFAULT_FACTORY = new CustomReaderFactory();
    }

    public static interface ICustomReaderFactory {
        public SamReader open(URL var1);
    }
}

