/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.BinaryCodec;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class BinaryBAMIndexWriter
implements BAMIndexWriter {
    protected final int nRef;
    private final BinaryCodec codec;
    private int count = 0;

    public BinaryBAMIndexWriter(int nRef, File output) {
        this.nRef = nRef;
        try {
            this.codec = new BinaryCodec(output, true);
            this.writeHeader();
        }
        catch (Exception e2) {
            throw new SAMException("Exception opening output file " + output, e2);
        }
    }

    public BinaryBAMIndexWriter(int nRef, OutputStream output) {
        this.nRef = nRef;
        try {
            this.codec = new BinaryCodec(output);
            this.writeHeader();
        }
        catch (Exception e2) {
            throw new SAMException("Exception opening output stream", e2);
        }
    }

    @Override
    public void writeReference(BAMIndexContent content) {
        LinearIndex linearIndex;
        int size;
        if (content == null) {
            this.writeNullContent();
            ++this.count;
            return;
        }
        if (content.getReferenceSequence() != this.count) {
            throw new SAMException("Unexpectedly writing reference " + content.getReferenceSequence() + ", expecting reference " + this.count);
        }
        ++this.count;
        BinningIndexContent.BinList bins = content.getBins();
        int n2 = size = bins == null ? 0 : content.getNumberOfNonNullBins();
        if (size == 0) {
            this.writeNullContent();
            return;
        }
        BAMIndexMetaData metaData = content.getMetaData();
        this.codec.writeInt(size + (metaData != null ? 1 : 0));
        for (Bin bin : bins) {
            if (bin.getBinNumber() == 37450) continue;
            this.writeBin(bin);
        }
        if (metaData != null) {
            this.writeChunkMetaData(metaData);
        }
        long[] entries = (linearIndex = content.getLinearIndex()) == null ? null : linearIndex.getIndexEntries();
        int indexStart = linearIndex == null ? 0 : linearIndex.getIndexStart();
        int n_intv = entries == null ? indexStart : entries.length + indexStart;
        this.codec.writeInt(n_intv);
        if (entries == null) {
            return;
        }
        for (int i2 = 0; i2 < indexStart; ++i2) {
            this.codec.writeLong(0L);
        }
        for (int k2 = 0; k2 < entries.length; ++k2) {
            this.codec.writeLong(entries[k2]);
        }
        try {
            this.codec.getOutputStream().flush();
        }
        catch (IOException e2) {
            throw new SAMException("IOException in BinaryBAMIndexWriter reference " + content.getReferenceSequence(), e2);
        }
    }

    @Override
    public void writeNoCoordinateRecordCount(Long count) {
        this.codec.writeLong(count == null ? 0L : count);
    }

    @Override
    public void close() {
        this.codec.close();
    }

    private void writeBin(Bin bin) {
        int binNumber = bin.getBinNumber();
        if (binNumber >= 37450) {
            throw new SAMException("Unexpected bin number when writing bam index " + binNumber);
        }
        this.codec.writeInt(binNumber);
        if (bin.getChunkList() == null) {
            this.codec.writeInt(0);
            return;
        }
        List<Chunk> chunkList = bin.getChunkList();
        int n_chunk = chunkList.size();
        this.codec.writeInt(n_chunk);
        for (Chunk c2 : chunkList) {
            this.codec.writeLong(c2.getChunkStart());
            this.codec.writeLong(c2.getChunkEnd());
        }
    }

    private void writeChunkMetaData(BAMIndexMetaData metaData) {
        this.codec.writeInt(37450);
        int nChunk = 2;
        this.codec.writeInt(2);
        this.codec.writeLong(metaData.getFirstOffset());
        this.codec.writeLong(metaData.getLastOffset());
        this.codec.writeLong(metaData.getAlignedRecordCount());
        this.codec.writeLong(metaData.getUnalignedRecordCount());
    }

    private void writeHeader() {
        byte[] magic = BAMFileConstants.BAM_INDEX_MAGIC;
        this.codec.writeBytes(magic);
        this.codec.writeInt(this.nRef);
    }

    private void writeNullContent() {
        this.codec.writeLong(0L);
    }
}

