/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedVector<E>
extends Vector<E> {
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> c2) {
        super(c2);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public int indexOf(Object elem) {
        this.initializeCache();
        Integer o2 = this._indexCache.get(elem);
        if (o2 != null) {
            return o2;
        }
        if (this.isLazyCaching()) {
            int i2 = super.indexOf(elem);
            if (i2 == -1) {
                this.uncacheIt(elem);
            } else {
                this.cacheIt(elem, i2);
            }
            return i2;
        }
        return -1;
    }

    protected synchronized void adjustCache(int index, int increase) {
        if (this._indexCache != null) {
            Map<Object, Integer> newCache = this.createCache();
            Set<Object> keys = this._indexCache.keySet();
            for (Object key : keys) {
                int value = this._indexCache.get(key);
                if (value >= index) {
                    newCache.put(key, value + increase);
                    continue;
                }
                newCache.put(key, value);
            }
            this._indexCache = newCache;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public synchronized void cacheIt(Object o2, int index) {
        if (this._indexCache != null && (this._indexCache.get(o2) == null || index < this._indexCache.get(o2))) {
            this._indexCache.put(o2, index);
        }
    }

    public synchronized void uncacheIt(Object o2) {
        if (this._indexCache != null) {
            this._indexCache.remove(o2);
        }
    }

    @Override
    public boolean add(E element) {
        boolean added = super.add(element);
        if (!this.isLazyCaching() && added) {
            this.initializeCache();
            this.cacheIt(element, this.size() - 1);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        } else if (this._indexCache != null) {
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int index) {
        Object element = super.remove(index);
        if (element != null) {
            this.uncacheIt(element);
            this.adjustCache(index, -1);
        }
        return element;
    }

    @Override
    public boolean remove(Object o2) {
        int oldIndex = this.indexOf(o2);
        boolean removed = super.remove(o2);
        if (removed) {
            this.uncacheIt(o2);
            this.adjustCache(oldIndex, -1);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        this.uncacheAll();
        return super.removeAll(c2);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        boolean added = super.addAll(c2);
        if (added) {
            this.cacheAll();
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c2) {
        boolean added = super.addAll(index, c2);
        this.initializeCache();
        this.adjustCache(index, c2.size());
        for (E e2 : c2) {
            this.cacheIt(e2, index++);
        }
        return added;
    }

    @Override
    public E set(int index, E element) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e2 = super.set(index, element);
            this.uncacheIt(e2);
            this.cacheIt(element, index);
            return e2;
        }
        return super.set(index, element);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer i2 = 0;
        for (Object elem : this) {
            if (this._indexCache.get(elem) == null) {
                this._indexCache.put(elem, i2);
            }
            Integer n2 = i2;
            Integer n3 = i2 = Integer.valueOf(i2 + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean lazyCaching) {
        this._lazyCaching = lazyCaching;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
        } else {
            super.removeRange(fromIndex, toIndex);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

