/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.office2007;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class Office2007Painter
extends BasicPainter {
    public static final String IS_MENU_PART_BUTTON = "isMenuPartButton";
    private static Office2007Painter _instance;
    private ThemePainter _defaultPainter;
    private static final Color[] STATUS_BAR_BG;
    private static final Color[] SPECIAL_STATUS_BAR_BG;
    private static final Color[] DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new Office2007Painter();
        }
        return _instance;
    }

    protected Office2007Painter() {
    }

    protected ThemePainter createDefaultPainter() {
        return Office2003Painter.getInstance();
    }

    public ThemePainter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = this.createDefaultPainter();
        }
        return this._defaultPainter;
    }

    public void installDefaults() {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.installDefaults();
        }
    }

    public void uninstallDefaults() {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.uninstallDefaults();
        }
    }

    public Color getMenuItemBorderColor() {
        return new Color(100, 100, 100);
    }

    public void paintContentBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g2.create();
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        g2d.setColor(highContrast != false ? UIDefaultsLookup.getColor("Content.background") : new Color(0xBFDBFF));
        g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2d.dispose();
    }

    private void paintButtonBorder(Component c2, Graphics g2, Rectangle rect, int state) {
        int x2 = rect.x;
        int y = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        Graphics2D gfx = (Graphics2D)g2;
        if (state == 3 || state == 1) {
            gfx.setColor(new Color(9139796));
            gfx.drawLine(x2 + 1, y, x2 + w2 - 2, y);
            gfx.setPaint(new GradientPaint(x2, y + 1, new Color(9139796), x2, y + h2 - 3, new Color(12892584)));
            gfx.drawLine(x2, y + 1, x2, y + h2 - 3);
            gfx.drawLine(x2 + w2 - 1, y + 1, x2 + w2 - 1, y + h2 - 3);
            gfx.setColor(new Color(15977082));
            gfx.drawLine(x2, y + h2 - 3, x2, y + h2 - 3);
            gfx.drawLine(x2 + w2 - 1, y + h2 - 3, x2 + w2 - 1, y + h2 - 3);
            if (c2 instanceof JideSplitButton && BasicJideButtonUI.shouldWrapText(c2)) {
                gfx.setColor(new Color(13680517));
                gfx.drawLine(x2, y + h2 - 30, x2 + w2, y + h2 - 30);
            }
        } else if (state == 2) {
            if (h2 != 0) {
                Paint lgp = JideSwingUtilities.getLinearGradientPaint(x2, y, x2, y + h2, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14207638), new Color(12165236), new Color(12102030)});
                gfx.setPaint(lgp);
            }
            gfx.drawLine(x2, y + 1, x2, h2 - 2);
            gfx.setColor(new Color(14405273));
            gfx.drawLine(x2 + 1, y, x2 + w2 - 2, y);
            gfx.setPaint(new GradientPaint(x2, y + h2, new Color(12299927), x2 + (w2 >> 1), y + h2, new Color(13353898), true));
            gfx.drawLine(x2 + 1, y + h2 - 1, x2 + w2 - 2, y + h2 - 1);
            if (h2 - 1 != 0) {
                gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + w2 - 1, y, x2 + w2 - 1, y + h2 - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14470810), new Color(12823418), new Color(13815481)}));
            }
            gfx.drawLine(x2 + w2 - 1, y + 1, x2 + w2 - 1, y + h2 - 2);
            gfx.setColor(new Color(15393448));
            gfx.drawLine(x2 + 1, y + 1, x2 + 1, y + 1);
            gfx.drawLine(x2 + w2 - 2, y + 1, x2 + w2 - 2, y + 1);
            gfx.setColor(new Color(15786940));
            gfx.drawLine(x2 + 1, y + h2 - 2, x2 + 1, y + h2 - 2);
            gfx.drawLine(x2 + w2 - 2, y + h2 - 2, x2 + w2 - 2, y + h2 - 2);
        } else if (state == 0) {
            gfx.setColor(new Color(7836601));
            if (c2 instanceof JideButton && ((JideButton)c2).getButtonStyle() == 0) {
                gfx.drawLine(x2 + 1, y, x2 + w2 - 2, y);
                gfx.drawLine(x2, y + 1, x2, y + h2 - 2);
                gfx.drawLine(x2 + w2 - 1, y + 1, x2 + w2 - 1, y + h2 - 2);
                gfx.drawLine(x2 + 1, y + h2 - 1, x2 + w2 - 2, y + h2 - 1);
                gfx.setColor(new Color(10269908));
                gfx.drawLine(x2 + 1, y + 1, x2 + 1, y + 1);
                gfx.drawLine(x2 + 1, y + h2 - 2, x2 + 1, y + h2 - 2);
                gfx.drawLine(x2 + w2 - 2, y + 1, x2 + w2 - 2, y + 1);
                gfx.drawLine(x2 + w2 - 2, y + h2 - 2, x2 + w2 - 2, y + h2 - 2);
            } else {
                gfx.drawLine(x2 + 1, y, x2 + w2 - 1, y);
                gfx.drawLine(x2, y + 1, x2, y + h2 - 1);
                gfx.drawLine(x2 + w2 - 1, y + 1, x2 + w2 - 1, y + h2 - 1);
                gfx.drawLine(x2 + 1, y + h2 - 1, x2 + w2 - 1, y + h2 - 1);
            }
        }
    }

    public void paintButtonBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state, boolean showBorder) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintButtonBackground(c2, g2, rect, orientation, state, showBorder);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintButtonBackground(c2, g2, rect, orientation, state, showBorder);
            return;
        }
        Color background = null;
        switch (state) {
            case 0: {
                background = c2.getBackground();
                break;
            }
            case 2: {
                if (!(c2 instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c2)).getBackgroundOfState(state);
                break;
            }
            case 3: {
                if (!(c2 instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c2)).getBackgroundOfState(state);
                break;
            }
            case 5: {
                if (!(c2 instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c2)).getBackgroundOfState(state);
                break;
            }
            case 1: {
                if (!(c2 instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c2)).getBackgroundOfState(state);
            }
        }
        if (background != null && !(background instanceof UIResource)) {
            this.getDefaultPainter().paintButtonBackground(c2, g2, rect, orientation, state, showBorder);
            return;
        }
        int x2 = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (!showBorder) {
            --x2;
            --y;
            width += 2;
            height += 2;
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        if (state == 1) {
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, new Color[]{new Color(16624913), new Color(16161816), new Color(16229415), new Color(15771740)}, new Color[]{new Color(16623720), new Color(16551741), new Color(16560957)});
        } else if (state == 2) {
            if (c2.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
                if (1 != height - 2) {
                    g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 1, y + 1, x2 + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(0xFFFEE2), new Color(16768115), new Color(16766560), new Color(16771752)}));
                }
                g2d.fillRect(x2 + 1, y + 1, width - 2, height - 2);
            } else {
                g2d.setPaint(new GradientPaint(x2, y, new Color(0xFFFFFF), x2, y + height, new Color(16773982)));
                g2d.fillRect(x2 + 1, y + 1, width - 2, height - 2);
                g2d.setPaint(new GradientPaint(x2, y, new Color(16775058), x2 + width >> 1, y, new Color(0xFFFFFF), true));
                g2d.drawLine(x2, y + height - 2, x2 + width, y + height - 2);
                if (2 != height - 4) {
                    g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 2, y + 2, x2 + 2, y + height - 4, new float[]{0.0f, 0.36f, 0.37f, 0.38f, 1.0f}, new Color[]{new Color(0xFFFDDF), new Color(16770964), new Color(16699744), new Color(16698712), new Color(16770964)}));
                }
                g2d.fillRect(x2 + 2, y + 2, width - 4, height - 4);
            }
        } else if (state == 3) {
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, new Color[]{new Color(15978405), new Color(15774041), new Color(15839569), new Color(16500832)}, new Color[]{new Color(16633240), new Color(16298843), new Color(16504194)});
        } else if (state == 5) {
            int i2;
            Color[] baseColors = new Color[]{new Color(15978405), new Color(15774041), new Color(15839569), new Color(16500832)};
            Color[] innerBackgroundColors = new Color[]{new Color(16633240), new Color(16298843), new Color(16504194)};
            int length = baseColors.length;
            for (i2 = 0; i2 < length; ++i2) {
                baseColors[i2] = ColorUtils.toGrayscale(baseColors[i2]);
            }
            length = innerBackgroundColors.length;
            for (i2 = 0; i2 < length; ++i2) {
                innerBackgroundColors[i2] = ColorUtils.toGrayscale(innerBackgroundColors[i2]);
            }
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, baseColors, innerBackgroundColors);
        } else if (state == 0) {
            if (1 != height - 2) {
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 1, y + 1, x2 + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)}));
            }
            g2d.fillRect(x2 + 1, y + 1, width - 2, height - 2);
        }
        if (showBorder) {
            g2d.setComposite(AlphaComposite.getInstance(10));
            this.paintButtonBorder(c2, g2d, rect, state);
        }
        g2d.dispose();
    }

    static void paintShadowedButtonBackground(Graphics2D gfx, Rectangle rect, Color[] baseColors, Color[] innerBackgroundColors) {
        assert (baseColors.length == 4 && innerBackgroundColors.length == 3);
        int x2 = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (1 != height - 2) {
            gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 1, y + 1, x2 + width - 2, y + height - 2, new float[]{0.0f, 0.6f, 0.61f, 1.0f}, baseColors));
        }
        gfx.fillRect(x2 + 1, y + 1, width - 2, height - 2);
        Area base = new Area(new Rectangle(x2 + 2, y + 1, width - 4, height - 3));
        base.subtract(new Area(new Rectangle(x2 + 2, y + height - 3, 1, 1)));
        base.subtract(new Area(new Rectangle(x2 + width - 3, y + height - 3, 1, 1)));
        if (2 != height - 4) {
            gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 2, y + 2, x2 + 2, y + height - 4, new float[]{0.39f, 0.4f, 1.0f}, innerBackgroundColors));
        }
        gfx.fill(base);
    }

    public void paintStatusBarBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (c2.isOpaque()) {
            Color[] bg = state == 0 ? STATUS_BAR_BG : SPECIAL_STATUS_BAR_BG;
            Graphics2D g2d = (Graphics2D)g2.create();
            int y = rect.y;
            g2d.setColor(bg[0]);
            g2d.drawLine(rect.x, y, rect.x + rect.width, y);
            g2d.setColor(bg[1]);
            g2d.drawLine(rect.x, ++y, rect.x + rect.width, y);
            Rectangle r2 = new Rectangle(rect.x, ++y, rect.width, (rect.height - 4) / 3);
            JideSwingUtilities.fillGradient(g2d, r2, bg[2], bg[3], true);
            r2.y += r2.height;
            r2.height = rect.height - r2.y - 2;
            JideSwingUtilities.fillGradient(g2d, r2, bg[4], bg[5], true);
            y = r2.y + r2.height;
            g2d.setColor(bg[6]);
            g2d.drawLine(rect.x, y, rect.x + rect.width, y);
            g2d.setColor(bg[7]);
            g2d.drawLine(rect.x, ++y, rect.x + rect.width, y);
            g2d.dispose();
        }
    }

    public void paintStatusBarSeparator(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(new Color(9284821));
        g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        g2.setColor(new Color(0xFFFFFF));
        g2.drawLine(rect.x + 1, rect.y, rect.x + 1, rect.y + rect.height);
    }

    public void paintMenuShadow(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (c2.getClientProperty("vsnet.paintShadow") != Boolean.FALSE) {
            super.paintMenuShadow(c2, g2, rect, orientation, state);
            g2.setColor(new Color(0xC5C5C5));
            g2.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        } else {
            g2.setColor(this.getMenuItemBackground());
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void paintMenuItemBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state, boolean showBorder) {
        if (c2.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
            this.paintButtonBackground(c2, g2, rect, orientation, state, showBorder);
        } else {
            JideSwingUtilities.drawImageBorder(g2, IconsFactory.getImageIcon(Office2007Painter.class, "icons/menu_item_bg.png"), rect, new Insets(2, 2, 2, 2), true);
        }
    }

    public void paintPopupMenuSeparator(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        super.paintPopupMenuSeparator(c2, g2, rect, orientation, state);
        g2.setColor(new Color(0xC5C5C5));
        g2.drawLine(rect.x + 24, rect.y, rect.x + 24, rect.y + rect.height);
    }

    public void paintDropDownIcon(Graphics g2, int x2, int y) {
        g2.setColor(new Color(5668273));
        g2.drawLine(x2, y, x2 + 5, y);
        g2.drawLine(x2 + 1, y + 1, x2 + 4, y + 1);
        g2.drawLine(x2 + 2, y + 2, x2 + 3, y + 2);
    }

    public void paintCommandBarBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCommandBarBackground(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCommandBarBackground(c2, g2, rect, orientation, state);
            return;
        }
        int x2 = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Graphics2D g2d = (Graphics2D)g2.create();
        Color[] colors = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            Color color = colors[i2];
            colors[i2] = ColorUtils.getDerivedColor(color, 0.47f);
        }
        if (1 != height - 2) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 1, y + 1, x2 + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colors));
        }
        g2d.fillRect(x2 + 1, y + 1, width - 2, height - 2);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(10);
        g2d.setComposite(SystemInfo.isJdk6Above() ? alphaComposite.derive(0.1f) : AlphaComposite.getInstance(alphaComposite.getRule(), 0.1f));
        this.paintButtonBorder(c2, g2d, rect, state);
        g2d.dispose();
    }

    public void paintFloatingCommandBarBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintFloatingCommandBarBackground(c2, g2, rect, orientation, state);
            return;
        }
        int x2 = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Graphics2D g2d = (Graphics2D)g2.create();
        Color[] colors = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            Color color = colors[i2];
            colors[i2] = ColorUtils.getDerivedColor(color, 0.48f);
        }
        if (height != 0) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2, y, x2, y + height, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colors));
        }
        g2d.fillRect(x2, y, width, height);
        g2d.dispose();
    }

    public void paintDockableFrameTitlePane(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintDockableFrameTitlePane(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintDockableFrameTitlePane(c2, g2, rect, orientation, state);
            return;
        }
        int x2 = rect.x;
        int y = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        if (c2.getBorder() != null) {
            Insets insets = c2.getBorder().getBorderInsets(c2);
            x2 += insets.left;
            y += insets.top;
            w2 -= insets.right + insets.left;
            h2 -= insets.top + insets.bottom;
        }
        boolean active = state == 3;
        Color[] colors = active ? ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG : DOCKABLE_FRAME_TITLE_BAR_BG;
        Graphics2D g2d = (Graphics2D)g2.create();
        Color old = g2d.getColor();
        g2d.setColor(Color.WHITE);
        g2d.drawLine(x2, y, x2 + w2, y);
        g2d.drawLine(x2, y, x2, y + h2);
        g2d.setColor(old);
        if (h2 != 0) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2 + 1, y + 1, x2 + 1, y + h2 - 1, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors));
        }
        g2d.fillRect(x2 + 1, y + 1, w2 - 1, h2 - 1);
        g2d.dispose();
    }

    public void paintCollapsiblePaneTitlePaneBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackground(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackground(c2, g2, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePane(c2, g2, rect, COLLAPSIBLE_PANE_TITLE_BAR_BG, orientation, state);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundEmphasized(c2, g2, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePane(c2, g2, rect, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG, orientation, state);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(c2, g2, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(c2, g2, rect, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, state);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparator(c2, g2, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparator(c2, g2, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(c2, g2, rect, COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, state);
    }

    private void paintCollapsiblePaneTitlePane(JComponent c2, Graphics g2, Rectangle rect, Color[] colors, int orientation, int state) {
        int x2 = rect.x;
        int y = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        if (c2.getBorder() != null) {
            Insets insets = c2.getBorder().getBorderInsets(c2);
            x2 += insets.left;
            y += insets.top;
            w2 -= insets.right + insets.left;
            h2 -= insets.top + insets.bottom;
        }
        if (h2 != 0) {
            Graphics2D g2d = (Graphics2D)g2.create();
            Paint paint = null;
            switch (orientation) {
                case 3: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i2 = 0; i2 < colors.length; ++i2) {
                            Color color = colors[i2];
                            newColors[i2] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x2, y, x2 + w2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x2, y, x2 + w2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 7: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i3 = 0; i3 < colors.length; ++i3) {
                            Color color = colors[i3];
                            newColors[i3] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x2 + w2, y, x2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x2 + w2, y, x2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 1: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i4 = 0; i4 < colors.length; ++i4) {
                            Color color = colors[i4];
                            newColors[i4] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x2, y + h2, x2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x2, y + h2, x2, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 5: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i5 = 0; i5 < colors.length; ++i5) {
                            Color color = colors[i5];
                            newColors[i5] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x2, y, x2, y + h2, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x2, y, x2, y + h2, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                }
            }
            g2d.setPaint(paint);
            g2d.fillRect(x2, y, w2, h2);
            g2d.dispose();
        }
    }

    private void paintCollapsiblePaneTitlePaneSeparator(JComponent c2, Graphics g2, Rectangle rect, Color[] colors, int state) {
        int x2 = rect.x;
        int y = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        if (c2.getBorder() != null) {
            Insets insets = c2.getBorder().getBorderInsets(c2);
            x2 += insets.left;
            y += insets.top;
            w2 -= insets.right + insets.left;
            h2 -= insets.top + insets.bottom;
        }
        if (h2 != 0) {
            Graphics2D g2d = (Graphics2D)g2.create();
            if (state == 2) {
                Color[] newColors = new Color[colors.length];
                for (int i2 = 0; i2 < colors.length; ++i2) {
                    Color color = colors[i2];
                    newColors[i2] = ColorUtils.getDerivedColor(color, 0.6f);
                }
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2, y, x2 + w2, y, new float[]{0.0f, 0.5f, 1.0f}, newColors));
            } else {
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x2, y, x2 + w2, y, new float[]{0.0f, 0.5f, 1.0f}, colors));
            }
            g2d.fillRect(x2, y, w2, h2);
            g2d.dispose();
        }
    }

    public void paintCollapsiblePanesBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!c2.isOpaque()) {
            return;
        }
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePanesBackground(c2, g2, rect, orientation, state);
            return;
        }
        Graphics2D g2d = (Graphics2D)g2;
        if (!(c2.getBackground() instanceof UIResource)) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), c2.getBackground(), ColorUtils.getDerivedColor(c2.getBackground(), 0.6f), orientation == 0);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundLt"), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundDk"), orientation == 0);
        }
    }

    public void paintSidePaneItemBackground(JComponent c2, Graphics g2, Rectangle rect, Color[] colors, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue() || colors != null && colors.length >= 1 && colors[0] != null && !(colors[0] instanceof UIResource)) {
            super.paintSidePaneItemBackground(c2, g2, rect, colors, orientation, state);
            return;
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        switch (orientation) {
            case 3: 
            case 7: {
                g2d.rotate(-Math.toRadians(90.0), rect.x, rect.y);
                g2d.translate(-rect.height, rect.y);
                this.paintButtonBackground(c2, g2d, new Rectangle(0, 0, rect.height, rect.width), 0, state, false);
                break;
            }
            case 1: 
            case 5: {
                this.paintButtonBackground(c2, g2d, rect, 0, state, false);
            }
        }
        g2d.dispose();
    }

    public void paintHeaderBoxBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        boolean paintBorder = !(c2 instanceof AbstractButton) || ((AbstractButton)c2).isBorderPainted();
        this.paintButtonBackground(c2, g2, rect, orientation, state, paintBorder);
        if (!paintBorder) {
            Color old = g2.getColor();
            g2.setColor(UIDefaultsLookup.getColor("Table.gridColor"));
            g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
            g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            g2.setColor(old);
        }
    }

    public void paintGripper(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (rect.width > 30) {
            orientation = 1;
        } else if (rect.height > 30) {
            orientation = 0;
        }
        int h2 = orientation == 0 ? rect.height : rect.width;
        int count = Math.min(9, (h2 - 6) / 4);
        int y = rect.y;
        int x2 = rect.x;
        if (orientation == 0) {
            y += rect.height / 2 - count * 2;
            x2 += rect.width / 2 - 1;
        } else {
            x2 += rect.width / 2 - count * 2;
            y += rect.height / 2 - 1;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            g2.setColor(this.getGripperForegroundLt());
            g2.fillRect(x2 + 1, y + 1, 2, 2);
            g2.setColor(this.getGripperForeground());
            g2.fillRect(x2, y, 2, 2);
            g2.setColor(ColorUtils.getDerivedColor(this.getGripperForeground(), 0.55f));
            g2.fillRect(x2 + 1, y + 1, 1, 1);
            if (orientation == 0) {
                y += 4;
                continue;
            }
            x2 += 4;
        }
    }

    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("Gripper.light");
    }

    public Color getSelectionSelectedDk() {
        return new ColorUIResource(16305011);
    }

    public Color getSelectionSelectedLt() {
        return new ColorUIResource(16710613);
    }

    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    public void fillBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state, Color color) {
        Graphics2D g2d = (Graphics2D)g2.create();
        if (orientation == 0) {
            int topHeight = rect.height / 3;
            JideSwingUtilities.fillGradient((Graphics2D)g2, new Rectangle(rect.x, rect.y, rect.width, topHeight), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), true);
            JideSwingUtilities.fillGradient((Graphics2D)g2, new Rectangle(rect.x, rect.y + topHeight, rect.width, rect.height - topHeight), color, ColorUtils.getDerivedColor(color, 0.64f), true);
        } else {
            int leftWidth = rect.width / 3;
            JideSwingUtilities.fillGradient((Graphics2D)g2, new Rectangle(rect.x, rect.y, leftWidth, rect.height), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), false);
            JideSwingUtilities.fillGradient((Graphics2D)g2, new Rectangle(rect.x + leftWidth, rect.y, rect.width - leftWidth, rect.height), color, ColorUtils.getDerivedColor(color, 0.64f), false);
        }
        g2d.dispose();
    }

    static {
        STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(0xFFFFFF), new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111), new Color(13492471), new Color(12244215)};
        SPECIAL_STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(12967160), new Color(12769783), new Color(11127543), new Color(9484010), new Color(7772357), new Color(7640514), new Color(9809358)};
        DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(15070461), new Color(14217212), new Color(12510973), new Color(10934772)};
        ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(16769959), new Color(16764785), new Color(16761679), new Color(16762964)};
        COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(15200510), new Color(12178423), new Color(10863853), new Color(9415117)};
        COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(13098232), new Color(14149369), new Color(13098232)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(12178423), new Color(15200510), new Color(12178423)};
    }
}

