/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import picard.PicardException;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.fakers.FileFaker;
import picard.illumina.parser.readers.BclReader;

public class PerTilePerCycleFileUtil
extends ParameterizedFileUtil {
    private final CycleIlluminaFileMap cycleFileMap;
    private final Set<Integer> detectedCycles = new TreeSet<Integer>();

    public PerTilePerCycleFileUtil(String extension, File base, FileFaker faker, int lane) {
        super(true, extension, base, faker, lane);
        this.cycleFileMap = this.getPerTilePerCycleFiles();
    }

    protected CycleIlluminaFileMap getPerTilePerCycleFiles() {
        CycleIlluminaFileMap cycledMap = new CycleIlluminaFileMap();
        File laneDir = this.base;
        File[] tempCycleDirs = IOUtil.getFilesMatchingRegexp(laneDir, IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN);
        if (tempCycleDirs == null || tempCycleDirs.length == 0) {
            return cycledMap;
        }
        for (File tempCycleDir : tempCycleDirs) {
            this.detectedCycles.add(PerTilePerCycleFileUtil.getCycleFromDir(tempCycleDir));
        }
        HashSet uniqueTiles = new HashSet();
        for (File cycleDir : tempCycleDirs) {
            IlluminaFileMap fileMap = this.getTiledFiles(cycleDir, this.matchPattern);
            uniqueTiles.addAll(fileMap.keySet());
            cycledMap.put(PerTilePerCycleFileUtil.getCycleFromDir(cycleDir), fileMap);
        }
        this.tiles = Collections.unmodifiableList(new ArrayList(uniqueTiles));
        return cycledMap;
    }

    public CycleIlluminaFileMap getFiles() {
        return this.cycleFileMap;
    }

    public CycleIlluminaFileMap getFiles(List<Integer> tiles) {
        return this.cycleFileMap.keep(tiles, this.detectedCycles);
    }

    public CycleIlluminaFileMap getFiles(int[] cycles) {
        Set<Integer> filteredCycles = this.removeNonExistentCycles(cycles);
        return this.cycleFileMap.keep(this.tiles, filteredCycles);
    }

    public CycleIlluminaFileMap getFiles(List<Integer> tiles, int[] cycles) {
        Set<Integer> filteredCycles = this.removeNonExistentCycles(cycles);
        return this.cycleFileMap.keep(tiles, filteredCycles);
    }

    private Set<Integer> removeNonExistentCycles(int[] cycles) {
        TreeSet<Integer> inputCyclesSet = new TreeSet<Integer>();
        int[] arr$ = cycles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer inputCycle = arr$[i$];
            inputCyclesSet.add(inputCycle);
        }
        inputCyclesSet.retainAll(this.detectedCycles);
        return inputCyclesSet;
    }

    public Set<Integer> getDetectedCycles() {
        return this.detectedCycles;
    }

    @Override
    public List<Integer> getTiles() {
        return this.tiles;
    }

    @Override
    public boolean filesAvailable() {
        boolean filesAvailable = false;
        for (IlluminaFileMap fileMap : this.cycleFileMap.values()) {
            if (fileMap.isEmpty()) continue;
            filesAvailable = true;
            break;
        }
        return filesAvailable;
    }

    @Override
    public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
        LinkedList<String> failures = new LinkedList<String>();
        HashMap<Integer, Long> tileToFileLengthMap = new HashMap<Integer, Long>();
        if (!this.base.exists()) {
            failures.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else {
            CycleIlluminaFileMap cfm = this.getFiles(expectedTiles, expectedCycles);
            for (int currentCycle : expectedCycles) {
                IlluminaFileMap fileMap = (IlluminaFileMap)cfm.get(currentCycle);
                if (fileMap != null) {
                    for (int tile : expectedTiles) {
                        File cycleFile = (File)fileMap.get(tile);
                        if (cycleFile != null) {
                            if (tileToFileLengthMap.get(tile) == null) {
                                tileToFileLengthMap.put(tile, cycleFile.length());
                                continue;
                            }
                            if (this.extension.equals(".bcl.gz") || ((Long)tileToFileLengthMap.get(tile)).longValue() == cycleFile.length()) continue;
                            failures.add("File type " + this.extension + " has cycles files of different length.  Current cycle (" + currentCycle + ") " + "Length of first non-empty file (" + tileToFileLengthMap.get(tile) + ") length of current cycle (" + cycleFile.length() + ")" + " File(" + cycleFile.getAbsolutePath() + ")");
                            continue;
                        }
                        failures.add("File type " + this.extension + " is missing a file for cycle " + currentCycle + " and tile " + tile);
                    }
                    continue;
                }
                failures.add("Missing file for cycle " + currentCycle + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
            }
        }
        return failures;
    }

    @Override
    public List<String> fakeFiles(List<Integer> expectedTiles, int[] expectedCycles, IlluminaFileUtil.SupportedIlluminaFormat format) {
        LinkedList<String> failures = new LinkedList<String>();
        if (!this.base.exists()) {
            this.base.mkdirs();
        }
        TreeSet<Integer> missingCycleSet = new TreeSet<Integer>();
        int[] arr$ = expectedCycles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer cycle = arr$[i$];
            missingCycleSet.add(cycle);
        }
        missingCycleSet.removeAll(this.detectedCycles);
        for (Integer cycle : missingCycleSet) {
            File cycleDirectory = new File(this.base, "C" + cycle + ".1");
            if (!cycleDirectory.mkdirs()) continue;
            this.detectedCycles.add(cycle);
        }
        CycleIlluminaFileMap cfm = this.getPerTilePerCycleFiles();
        HashMap<Integer, Integer> tileToSizeMap = new HashMap<Integer, Integer>();
        for (int currentCycle : expectedCycles) {
            IlluminaFileMap fileMap = (IlluminaFileMap)cfm.get(currentCycle);
            if (fileMap == null) {
                for (Integer tile : expectedTiles) {
                    File fileToFake = new File(this.base + File.separator + this.getFileForCycle(currentCycle, tile));
                    try {
                        if (tileToSizeMap.containsKey(tile)) {
                            this.faker.fakeFile(fileToFake, (Integer)tileToSizeMap.get(tile));
                            continue;
                        }
                        this.faker.fakeFile(fileToFake, 1);
                    }
                    catch (IOException e2) {
                        failures.add("Could not create fake file: " + e2.getMessage());
                    }
                }
                continue;
            }
            for (int tile : expectedTiles) {
                File cycleFile = (File)fileMap.get(tile);
                if (cycleFile != null && !tileToSizeMap.containsKey(tile)) {
                    tileToSizeMap.put(tile, (int)BclReader.getNumberOfClusters(cycleFile));
                }
                try {
                    if (cycleFile != null) continue;
                    File fileToFake = new File(this.base + File.separator + this.getFileForCycle(currentCycle, tile));
                    if (tileToSizeMap.containsKey(tile)) {
                        this.faker.fakeFile(fileToFake, (Integer)tileToSizeMap.get(tile));
                        continue;
                    }
                    this.faker.fakeFile(fileToFake, 1);
                }
                catch (IOException e3) {
                    failures.add("Could not create fake file: " + e3.getMessage());
                }
            }
        }
        for (Integer cycle : missingCycleSet) {
            failures.add("Missing cycle directory " + cycle + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
        }
        return failures;
    }

    private String getFileForCycle(int currentCycle, int tile) {
        return "C" + currentCycle + ".1" + File.separator + "s_" + this.lane + "_" + tile + this.extension;
    }

    private static int getCycleFromDir(File tempCycleDir) {
        String fileName = tempCycleDir.getName();
        Matcher matcher = IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            throw new PicardException("Invalid cycle directory name " + tempCycleDir.getName());
        }
        return Integer.parseInt(matcher.group(1));
    }
}

