/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.SimpleDirectedGraph;

public class TransitiveClosure {
    public static final TransitiveClosure INSTANCE = new TransitiveClosure();

    private TransitiveClosure() {
    }

    public <V, E> void closeSimpleDirectedGraph(SimpleDirectedGraph<V, E> simpleDirectedGraph) {
        Set set = simpleDirectedGraph.vertexSet();
        HashSet hashSet = new HashSet();
        int n2 = this.computeBinaryLog(set.size());
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < n2; ++i2) {
            bl = true;
            for (Object v2 : set) {
                hashSet.clear();
                for (Object e2 : simpleDirectedGraph.outgoingEdgesOf(v2)) {
                    Object v3 = simpleDirectedGraph.getEdgeTarget(e2);
                    for (Object e3 : simpleDirectedGraph.outgoingEdgesOf(v3)) {
                        Object v4 = simpleDirectedGraph.getEdgeTarget(e3);
                        if (v2.equals(v4) || simpleDirectedGraph.getEdge(v2, v4) != null) continue;
                        hashSet.add(v4);
                        bl = false;
                    }
                }
                for (Object e2 : hashSet) {
                    simpleDirectedGraph.addEdge(v2, e2);
                }
            }
        }
    }

    private int computeBinaryLog(int n2) {
        assert (n2 >= 0);
        int n3 = 0;
        while (n2 > 0) {
            n2 >>= 1;
            ++n3;
        }
        return n3;
    }
}

