/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.cursor.CursorFilterDialog;
import org.broad.igv.cursor.CursorMainPanel;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.cursor.CursorUtils;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.util.encode.EncodeFileBrowser;
import org.broad.igv.util.encode.EncodeFileRecord;

public class CursorMainWindow
extends JFrame {
    CursorModel cursorModel;
    private static MouseAdapter nullMouseAdapter = new MouseAdapter(){};
    private static Map<String, Color> colors = new HashMap<String, Color>();
    private JMenuBar menuBar1;
    private JMenu fileMenu;
    private JMenuItem loadFileMenuItem;
    private JMenuItem loadEncodeMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu regionsMenu;
    private JMenuItem filterMenuItem;
    private CursorMainPanel cursorMainPanel1;
    private JPanel panel1;
    private JPanel panel2;
    private JLabel label2;
    private JTextField regionSizeTextField;
    private JPanel panel3;
    private JLabel label1;
    private JTextField frameWidthField;
    private JLabel regionsLabel;

    public static void main(String[] args) {
        new CursorMainWindow().setVisible(true);
    }

    public CursorMainWindow() {
        this.initComponents();
        this.cursorModel = new CursorModel(this);
        this.cursorMainPanel1.setModel(this.cursorModel);
        this.frameWidthField.setText(String.valueOf(this.cursorModel.getFramePixelWidth()));
        this.regionSizeTextField.setText(String.valueOf(this.cursorModel.getFrameBPWidth()));
        ToolTipManager.sharedInstance().setDismissDelay(20000);
    }

    void updateRegionsLabel() {
        int visibleRegionCount = (int)((double)this.getWidth() / this.cursorModel.getFramePixelWidth()) + 1;
        List<CursorRegion> filteredRegions = this.cursorModel.getFilteredRegions();
        if (filteredRegions != null) {
            this.regionsLabel.setText(" (" + visibleRegionCount + " / " + filteredRegions.size() + ")");
        }
    }

    private void frameWidthFieldActionPerformed(ActionEvent e2) {
        try {
            double newWidth = Double.parseDouble(this.frameWidthField.getText().trim());
            int regionCount = this.cursorModel.getFilteredRegions().size();
            if (regionCount > 0) {
                double minWidth = (double)this.cursorMainPanel1.getDataPanelWidth() / (double)regionCount;
                newWidth = Math.max(newWidth, minWidth);
                this.frameWidthField.setText(String.valueOf(newWidth));
            }
            if (newWidth > 0.0) {
                this.cursorModel.setFramePixelWidth(newWidth);
            }
            this.cursorMainPanel1.repaint();
            this.updateRegionsLabel();
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        System.exit(0);
    }

    private void regionSizeTextFieldActionPerformed(ActionEvent e2) {
        try {
            int newWidth = Integer.parseInt(this.regionSizeTextField.getText().trim());
            if (newWidth > 0) {
                this.cursorModel.setFrameBPWidth(newWidth);
            }
            this.cursorMainPanel1.repaint();
            this.updateRegionsLabel();
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
    }

    private void loadTracks(final Collection<EncodeFileRecord> records) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CursorMainWindow.this.startWaitCursor();
                    for (EncodeFileRecord record : records) {
                        boolean loadable;
                        String pathLC;
                        String path = record.getPath();
                        String name = record.getTrackName();
                        Color color = null;
                        String antibody = record.getAttributeValue("antibody");
                        if (antibody != null) {
                            color = (Color)colors.get(antibody.toUpperCase());
                        }
                        if ((pathLC = path.toLowerCase()).endsWith(".gz")) {
                            pathLC = pathLC.substring(0, pathLC.length() - 3);
                        }
                        if (!(loadable = pathLC.endsWith(".bed") || pathLC.endsWith(".narrowpeak") || pathLC.endsWith("broadpeak"))) continue;
                        try {
                            CursorTrack t2 = CursorUtils.loadTrack(path);
                            if (t2 == null) continue;
                            if (name != null) {
                                t2.setName(name);
                            }
                            if (color != null) {
                                t2.setColor(color);
                            }
                            CursorMainWindow.this.cursorModel.addTrack(t2);
                            if (CursorMainWindow.this.cursorModel.getFilteredRegions() == null || CursorMainWindow.this.cursorModel.getFilteredRegions().isEmpty()) {
                                CursorMainWindow.this.cursorModel.setRegions(CursorUtils.createRegions(t2));
                            }
                            CursorMainWindow.this.cursorMainPanel1.addTrack(t2);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CursorMainWindow.this.cursorMainPanel1.tracksAdded();
                            CursorMainWindow.this.cursorMainPanel1.revalidate();
                            CursorMainWindow.this.cursorMainPanel1.repaint();
                            CursorMainWindow.this.updateRegionsLabel();
                        }
                    });
                }
                finally {
                    CursorMainWindow.this.stopWaitCursor();
                }
            }
        };
        new Thread(runnable).start();
    }

    private void loadEncodeMenuItemActionPerformed(ActionEvent e2) {
        try {
            EncodeFileBrowser browser = EncodeFileBrowser.getInstance("hg19");
            browser.setVisible(true);
            if (browser.isCanceled()) {
                return;
            }
            List<EncodeFileRecord> records = browser.getSelectedRecords();
            if (records.size() > 0) {
                this.loadTracks(records);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void startWaitCursor() {
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().addMouseListener(nullMouseAdapter);
        this.getGlassPane().setVisible(true);
    }

    private void stopWaitCursor() {
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
        this.getGlassPane().removeMouseListener(nullMouseAdapter);
        this.getGlassPane().setVisible(false);
    }

    private void loadFIleMenuItemActionPerformed(ActionEvent e2) {
        File lastDirectoryFile = PreferenceManager.getInstance().getLastTrackDirectory();
        File[] trackFiles = FileDialogUtils.chooseMultiple("Select Files", lastDirectoryFile, new FilenameFilter(){

            @Override
            public boolean accept(File file, String s2) {
                return true;
            }
        });
        if (trackFiles == null || trackFiles.length == 0) {
            return;
        }
        PreferenceManager.getInstance().setLastTrackDirectory(trackFiles[0]);
        ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>();
        for (File f2 : trackFiles) {
            records.add(new EncodeFileRecord(f2.getPath(), new HashMap<String, String>()));
        }
        this.loadTracks(records);
    }

    private void filterMenuItemActionPerformed(ActionEvent e2) {
        CursorFilterDialog dlg = new CursorFilterDialog((Frame)this, this.cursorModel.getTracks(), this.cursorModel.getFilter());
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            // empty if block
        }
    }

    private void initComponents() {
        this.menuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadFileMenuItem = new JMenuItem();
        this.loadEncodeMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.regionsMenu = new JMenu();
        this.filterMenuItem = new JMenuItem();
        this.cursorMainPanel1 = new CursorMainPanel();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.regionSizeTextField = new JTextField();
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.frameWidthField = new JTextField();
        this.regionsLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 4));
        this.fileMenu.setText("File");
        this.loadFileMenuItem.setText("Load from file...");
        this.loadFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.loadFIleMenuItemActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadFileMenuItem);
        this.loadEncodeMenuItem.setText("Load from ENCODE...");
        this.loadEncodeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.loadEncodeMenuItemActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadEncodeMenuItem);
        this.fileMenu.addSeparator();
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.exitMenuItemActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar1.add(this.fileMenu);
        this.regionsMenu.setText("Regions");
        this.filterMenuItem.setText("Filter...");
        this.filterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.filterMenuItemActionPerformed(e2);
            }
        });
        this.regionsMenu.add(this.filterMenuItem);
        this.menuBar1.add(this.regionsMenu);
        this.setJMenuBar(this.menuBar1);
        this.cursorMainPanel1.setPreferredSize(new Dimension(135, 50));
        contentPane.add((Component)this.cursorMainPanel1, "Center");
        this.panel1.setLayout(new FlowLayout(2, 10, 0));
        this.panel2.setLayout(new FlowLayout(1, 5, 0));
        this.label2.setText("Region size (bp):");
        this.panel2.add(this.label2);
        this.regionSizeTextField.setPreferredSize(new Dimension(60, 28));
        this.regionSizeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.regionSizeTextFieldActionPerformed(e2);
            }
        });
        this.panel2.add(this.regionSizeTextField);
        this.panel1.add(this.panel2);
        this.panel3.setLayout(new FlowLayout(1, 5, 0));
        this.label1.setText("Frame width (pixels):");
        this.panel3.add(this.label1);
        this.frameWidthField.setMinimumSize(new Dimension(50, 50));
        this.frameWidthField.setPreferredSize(new Dimension(60, 28));
        this.frameWidthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorMainWindow.this.frameWidthFieldActionPerformed(e2);
            }
        });
        this.panel3.add(this.frameWidthField);
        this.regionsLabel.setHorizontalAlignment(2);
        this.regionsLabel.setMaximumSize(new Dimension(200, 0));
        this.regionsLabel.setPreferredSize(new Dimension(200, 28));
        this.regionsLabel.setHorizontalTextPosition(2);
        this.panel3.add(this.regionsLabel);
        this.panel1.add(this.panel3);
        contentPane.add((Component)this.panel1, "South");
        this.setSize(1075, 770);
        this.setLocationRelativeTo(this.getOwner());
    }

    static {
        colors = new HashMap<String, Color>();
        colors.put("H3K27AC", new Color(200, 0, 0));
        colors.put("H3K27ME3", new Color(200, 0, 0));
        colors.put("H3K36ME3", new Color(0, 0, 150));
        colors.put("H3K4ME1", new Color(0, 150, 0));
        colors.put("H3K4ME2", new Color(0, 150, 0));
        colors.put("H3K4ME3", new Color(0, 150, 0));
        colors.put("H3K9AC", new Color(100, 0, 0));
        colors.put("H3K9ME1", new Color(100, 0, 0));
    }
}

