/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.x509;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;

public class PEMUtil {
    private final String _header1;
    private final String _header2;
    private final String _footer1;
    private final String _footer2;

    PEMUtil(String type) {
        this._header1 = "-----BEGIN " + type + "-----";
        this._header2 = "-----BEGIN X509 " + type + "-----";
        this._footer1 = "-----END " + type + "-----";
        this._footer2 = "-----END X509 " + type + "-----";
    }

    private String readLine(InputStream in) throws IOException {
        int c2;
        StringBuffer l2 = new StringBuffer();
        while (true) {
            if ((c2 = in.read()) != 13 && c2 != 10 && c2 >= 0) {
                if (c2 == 13) continue;
                l2.append((char)c2);
                continue;
            }
            if (c2 < 0 || l2.length() != 0) break;
        }
        if (c2 < 0) {
            return null;
        }
        return l2.toString();
    }

    ASN1Sequence readPEMObject(InputStream in) throws IOException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        while ((line = this.readLine(in)) != null && !line.startsWith(this._header1) && !line.startsWith(this._header2)) {
        }
        while ((line = this.readLine(in)) != null && !line.startsWith(this._footer1) && !line.startsWith(this._footer2)) {
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            try {
                return ASN1Sequence.getInstance(Base64.decode(pemBuf.toString()));
            }
            catch (Exception e2) {
                throw new IOException("malformed PEM data encountered");
            }
        }
        return null;
    }
}

