/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.jacobians;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.ExtendedFirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.events.EventException;
import org.apache.commons.math.ode.events.EventHandler;
import org.apache.commons.math.ode.jacobians.EventHandlerWithJacobians;
import org.apache.commons.math.ode.jacobians.ODEWithJacobians;
import org.apache.commons.math.ode.jacobians.ParameterizedODE;
import org.apache.commons.math.ode.jacobians.StepHandlerWithJacobians;
import org.apache.commons.math.ode.jacobians.StepInterpolatorWithJacobians;
import org.apache.commons.math.ode.sampling.StepHandler;
import org.apache.commons.math.ode.sampling.StepInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FirstOrderIntegratorWithJacobians {
    private final FirstOrderIntegrator integrator;
    private final ODEWithJacobians ode;
    private int maxEvaluations;
    private int evaluations;

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ParameterizedODE ode, double[] p2, double[] hY, double[] hP) {
        this.checkDimension(ode.getDimension(), hY);
        this.checkDimension(ode.getParametersDimension(), p2);
        this.checkDimension(ode.getParametersDimension(), hP);
        this.integrator = integrator;
        this.ode = new FiniteDifferencesWrapper(ode, p2, hY, hP);
        this.setMaxEvaluations(-1);
    }

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ODEWithJacobians ode) {
        this.integrator = integrator;
        this.ode = ode;
        this.setMaxEvaluations(-1);
    }

    public void addStepHandler(StepHandlerWithJacobians handler) {
        int n2 = this.ode.getDimension();
        int k2 = this.ode.getParametersDimension();
        this.integrator.addStepHandler(new StepHandlerWrapper(handler, n2, k2));
    }

    public Collection<StepHandlerWithJacobians> getStepHandlers() {
        ArrayList<StepHandlerWithJacobians> handlers = new ArrayList<StepHandlerWithJacobians>();
        for (StepHandler handler : this.integrator.getStepHandlers()) {
            if (!(handler instanceof StepHandlerWrapper)) continue;
            handlers.add(((StepHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearStepHandlers() {
        this.integrator.clearStepHandlers();
    }

    public void addEventHandler(EventHandlerWithJacobians handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        int n2 = this.ode.getDimension();
        int k2 = this.ode.getParametersDimension();
        this.integrator.addEventHandler(new EventHandlerWrapper(handler, n2, k2), maxCheckInterval, convergence, maxIterationCount);
    }

    public Collection<EventHandlerWithJacobians> getEventHandlers() {
        ArrayList<EventHandlerWithJacobians> handlers = new ArrayList<EventHandlerWithJacobians>();
        for (EventHandler handler : this.integrator.getEventHandlers()) {
            if (!(handler instanceof EventHandlerWrapper)) continue;
            handlers.add(((EventHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearEventHandlers() {
        this.integrator.clearEventHandlers();
    }

    public double integrate(double t0, double[] y0, double[][] dY0dP, double t2, double[] y, double[][] dYdY0, double[][] dYdP) throws DerivativeException, IntegratorException {
        int n2 = this.ode.getDimension();
        int k2 = this.ode.getParametersDimension();
        this.checkDimension(n2, y0);
        this.checkDimension(n2, y);
        this.checkDimension(n2, dYdY0);
        this.checkDimension(n2, dYdY0[0]);
        if (k2 != 0) {
            this.checkDimension(n2, dY0dP);
            this.checkDimension(k2, dY0dP[0]);
            this.checkDimension(n2, dYdP);
            this.checkDimension(k2, dYdP[0]);
        }
        double[] z = new double[n2 * (1 + n2 + k2)];
        System.arraycopy(y0, 0, z, 0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            z[i2 * (1 + n2) + n2] = 1.0;
            System.arraycopy(dY0dP[i2], 0, z, n2 * (n2 + 1) + i2 * k2, k2);
        }
        this.evaluations = 0;
        double stopTime = this.integrator.integrate(new MappingWrapper(), t0, z, t2, z);
        FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, y, dYdY0, dYdP);
        return stopTime;
    }

    private static void dispatchCompoundState(double[] z, double[] y, double[][] dydy0, double[][] dydp) {
        int i2;
        int n2 = y.length;
        int k2 = dydp[0].length;
        System.arraycopy(z, 0, y, 0, n2);
        for (i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(z, n2 * (i2 + 1), dydy0[i2], 0, n2);
        }
        for (i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(z, n2 * (n2 + 1) + i2 * k2, dydp[i2], 0, k2);
        }
    }

    public double getCurrentStepStart() {
        return this.integrator.getCurrentStepStart();
    }

    public double getCurrentSignedStepsize() {
        return this.integrator.getCurrentSignedStepsize();
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    private void checkDimension(int expected, Object array) throws IllegalArgumentException {
        int arrayDimension;
        int n2 = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, arrayDimension, expected);
        }
    }

    private static class EventHandlerWrapper
    implements EventHandler {
        private final EventHandlerWithJacobians handler;
        private double[] y;
        private double[][] dydy0;
        private double[][] dydp;

        public EventHandlerWrapper(EventHandlerWithJacobians handler, int n2, int k2) {
            this.handler = handler;
            this.y = new double[n2];
            this.dydy0 = new double[n2][n2];
            this.dydp = new double[n2][k2];
        }

        public EventHandlerWithJacobians getHandler() {
            return this.handler;
        }

        public int eventOccurred(double t2, double[] z, boolean increasing) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            return this.handler.eventOccurred(t2, this.y, this.dydy0, this.dydp, increasing);
        }

        public double g(double t2, double[] z) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            return this.handler.g(t2, this.y, this.dydy0, this.dydp);
        }

        public void resetState(double t2, double[] z) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            this.handler.resetState(t2, this.y, this.dydy0, this.dydp);
        }
    }

    private static class StepInterpolatorWrapper
    implements StepInterpolatorWithJacobians {
        private StepInterpolator interpolator;
        private double[] y;
        private double[][] dydy0;
        private double[][] dydp;
        private double[] yDot;
        private double[][] dydy0Dot;
        private double[][] dydpDot;

        public StepInterpolatorWrapper() {
        }

        public StepInterpolatorWrapper(StepInterpolator interpolator, int n2, int k2) {
            this.interpolator = interpolator;
            this.y = new double[n2];
            this.dydy0 = new double[n2][n2];
            this.dydp = new double[n2][k2];
            this.yDot = new double[n2];
            this.dydy0Dot = new double[n2][n2];
            this.dydpDot = new double[n2][k2];
        }

        public void setInterpolatedTime(double time) {
            this.interpolator.setInterpolatedTime(time);
        }

        public boolean isForward() {
            return this.interpolator.isForward();
        }

        public double getPreviousTime() {
            return this.interpolator.getPreviousTime();
        }

        public double getInterpolatedTime() {
            return this.interpolator.getInterpolatedTime();
        }

        public double[] getInterpolatedY() throws DerivativeException {
            double[] extendedState = this.interpolator.getInterpolatedState();
            System.arraycopy(extendedState, 0, this.y, 0, this.y.length);
            return this.y;
        }

        public double[][] getInterpolatedDyDy0() throws DerivativeException {
            int n2;
            double[] extendedState = this.interpolator.getInterpolatedState();
            int start = n2 = this.y.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(extendedState, start, this.dydy0[i2], 0, n2);
                start += n2;
            }
            return this.dydy0;
        }

        public double[][] getInterpolatedDyDp() throws DerivativeException {
            double[] extendedState = this.interpolator.getInterpolatedState();
            int n2 = this.y.length;
            int k2 = this.dydp[0].length;
            int start = n2 * (n2 + 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(extendedState, start, this.dydp[i2], 0, k2);
                start += k2;
            }
            return this.dydp;
        }

        public double[] getInterpolatedYDot() throws DerivativeException {
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            System.arraycopy(extendedDerivatives, 0, this.yDot, 0, this.yDot.length);
            return this.yDot;
        }

        public double[][] getInterpolatedDyDy0Dot() throws DerivativeException {
            int n2;
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            int start = n2 = this.y.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(extendedDerivatives, start, this.dydy0Dot[i2], 0, n2);
                start += n2;
            }
            return this.dydy0Dot;
        }

        public double[][] getInterpolatedDyDpDot() throws DerivativeException {
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            int n2 = this.y.length;
            int k2 = this.dydpDot[0].length;
            int start = n2 * (n2 + 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(extendedDerivatives, start, this.dydpDot[i2], 0, k2);
                start += k2;
            }
            return this.dydpDot;
        }

        public double getCurrentTime() {
            return this.interpolator.getCurrentTime();
        }

        public StepInterpolatorWithJacobians copy() throws DerivativeException {
            int n2 = this.y.length;
            int k2 = this.dydp[0].length;
            StepInterpolatorWrapper copied = new StepInterpolatorWrapper(this.interpolator.copy(), n2, k2);
            StepInterpolatorWrapper.copyArray(this.y, copied.y);
            StepInterpolatorWrapper.copyArray(this.dydy0, copied.dydy0);
            StepInterpolatorWrapper.copyArray(this.dydp, copied.dydp);
            StepInterpolatorWrapper.copyArray(this.yDot, copied.yDot);
            StepInterpolatorWrapper.copyArray(this.dydy0Dot, copied.dydy0Dot);
            StepInterpolatorWrapper.copyArray(this.dydpDot, copied.dydpDot);
            return copied;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.interpolator);
            out.writeInt(this.y.length);
            out.writeInt(this.dydp[0].length);
            StepInterpolatorWrapper.writeArray(out, this.y);
            StepInterpolatorWrapper.writeArray(out, this.dydy0);
            StepInterpolatorWrapper.writeArray(out, this.dydp);
            StepInterpolatorWrapper.writeArray(out, this.yDot);
            StepInterpolatorWrapper.writeArray(out, this.dydy0Dot);
            StepInterpolatorWrapper.writeArray(out, this.dydpDot);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.interpolator = (StepInterpolator)in.readObject();
            int n2 = in.readInt();
            int k2 = in.readInt();
            this.y = new double[n2];
            this.dydy0 = new double[n2][n2];
            this.dydp = new double[n2][k2];
            this.yDot = new double[n2];
            this.dydy0Dot = new double[n2][n2];
            this.dydpDot = new double[n2][k2];
            StepInterpolatorWrapper.readArray(in, this.y);
            StepInterpolatorWrapper.readArray(in, this.dydy0);
            StepInterpolatorWrapper.readArray(in, this.dydp);
            StepInterpolatorWrapper.readArray(in, this.yDot);
            StepInterpolatorWrapper.readArray(in, this.dydy0Dot);
            StepInterpolatorWrapper.readArray(in, this.dydpDot);
        }

        private static void copyArray(double[] src, double[] dest) {
            System.arraycopy(src, 0, dest, 0, src.length);
        }

        private static void copyArray(double[][] src, double[][] dest) {
            for (int i2 = 0; i2 < src.length; ++i2) {
                StepInterpolatorWrapper.copyArray(src[i2], dest[i2]);
            }
        }

        private static void writeArray(ObjectOutput out, double[] array) throws IOException {
            for (int i2 = 0; i2 < array.length; ++i2) {
                out.writeDouble(array[i2]);
            }
        }

        private static void writeArray(ObjectOutput out, double[][] array) throws IOException {
            for (int i2 = 0; i2 < array.length; ++i2) {
                StepInterpolatorWrapper.writeArray(out, array[i2]);
            }
        }

        private static void readArray(ObjectInput in, double[] array) throws IOException {
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = in.readDouble();
            }
        }

        private static void readArray(ObjectInput in, double[][] array) throws IOException {
            for (int i2 = 0; i2 < array.length; ++i2) {
                StepInterpolatorWrapper.readArray(in, array[i2]);
            }
        }
    }

    private static class StepHandlerWrapper
    implements StepHandler {
        private final StepHandlerWithJacobians handler;
        private final int n;
        private final int k;

        public StepHandlerWrapper(StepHandlerWithJacobians handler, int n2, int k2) {
            this.handler = handler;
            this.n = n2;
            this.k = k2;
        }

        public StepHandlerWithJacobians getHandler() {
            return this.handler;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
            this.handler.handleStep(new StepInterpolatorWrapper(interpolator, this.n, this.k), isLast);
        }

        public boolean requiresDenseOutput() {
            return this.handler.requiresDenseOutput();
        }

        public void reset() {
            this.handler.reset();
        }
    }

    private class FiniteDifferencesWrapper
    implements ODEWithJacobians {
        private final ParameterizedODE ode;
        private final double[] p;
        private final double[] hY;
        private final double[] hP;
        private final double[] tmpDot;

        public FiniteDifferencesWrapper(ParameterizedODE ode, double[] p2, double[] hY, double[] hP) {
            this.ode = ode;
            this.p = (double[])p2.clone();
            this.hY = (double[])hY.clone();
            this.hP = (double[])hP.clone();
            this.tmpDot = new double[ode.getDimension()];
        }

        public int getDimension() {
            return this.ode.getDimension();
        }

        public void computeDerivatives(double t2, double[] y, double[] yDot) throws DerivativeException {
            this.ode.computeDerivatives(t2, y, yDot);
        }

        public int getParametersDimension() {
            return this.ode.getParametersDimension();
        }

        public void computeJacobians(double t2, double[] y, double[] yDot, double[][] dFdY, double[][] dFdP) throws DerivativeException {
            int j2;
            int n2 = this.hY.length;
            int k2 = this.hP.length;
            FirstOrderIntegratorWithJacobians.this.evaluations += n2 + k2;
            if (FirstOrderIntegratorWithJacobians.this.evaluations > FirstOrderIntegratorWithJacobians.this.maxEvaluations) {
                throw new DerivativeException(new MaxEvaluationsExceededException(FirstOrderIntegratorWithJacobians.this.maxEvaluations));
            }
            for (j2 = 0; j2 < n2; ++j2) {
                double savedYj = y[j2];
                int n3 = j2;
                y[n3] = y[n3] + this.hY[j2];
                this.ode.computeDerivatives(t2, y, this.tmpDot);
                for (int i2 = 0; i2 < n2; ++i2) {
                    dFdY[i2][j2] = (this.tmpDot[i2] - yDot[i2]) / this.hY[j2];
                }
                y[j2] = savedYj;
            }
            for (j2 = 0; j2 < k2; ++j2) {
                this.ode.setParameter(j2, this.p[j2] + this.hP[j2]);
                this.ode.computeDerivatives(t2, y, this.tmpDot);
                for (int i3 = 0; i3 < n2; ++i3) {
                    dFdP[i3][j2] = (this.tmpDot[i3] - yDot[i3]) / this.hP[j2];
                }
                this.ode.setParameter(j2, this.p[j2]);
            }
        }
    }

    private class MappingWrapper
    implements ExtendedFirstOrderDifferentialEquations {
        private final double[] y;
        private final double[] yDot;
        private final double[][] dFdY;
        private final double[][] dFdP;

        public MappingWrapper() {
            int n2 = FirstOrderIntegratorWithJacobians.this.ode.getDimension();
            int k2 = FirstOrderIntegratorWithJacobians.this.ode.getParametersDimension();
            this.y = new double[n2];
            this.yDot = new double[n2];
            this.dFdY = new double[n2][n2];
            this.dFdP = new double[n2][k2];
        }

        public int getDimension() {
            int n2 = this.y.length;
            int k2 = this.dFdP[0].length;
            return n2 * (1 + n2 + k2);
        }

        public int getMainSetDimension() {
            return FirstOrderIntegratorWithJacobians.this.ode.getDimension();
        }

        public void computeDerivatives(double t2, double[] z, double[] zDot) throws DerivativeException {
            double[] dFdYi;
            int i2;
            int n2 = this.y.length;
            int k2 = this.dFdP[0].length;
            System.arraycopy(z, 0, this.y, 0, n2);
            if (++FirstOrderIntegratorWithJacobians.this.evaluations > FirstOrderIntegratorWithJacobians.this.maxEvaluations) {
                throw new DerivativeException(new MaxEvaluationsExceededException(FirstOrderIntegratorWithJacobians.this.maxEvaluations));
            }
            FirstOrderIntegratorWithJacobians.this.ode.computeDerivatives(t2, this.y, this.yDot);
            FirstOrderIntegratorWithJacobians.this.ode.computeJacobians(t2, this.y, this.yDot, this.dFdY, this.dFdP);
            System.arraycopy(this.yDot, 0, zDot, 0, n2);
            for (i2 = 0; i2 < n2; ++i2) {
                dFdYi = this.dFdY[i2];
                for (int j2 = 0; j2 < n2; ++j2) {
                    int startIndex;
                    double s2 = 0.0;
                    int zIndex = startIndex = n2 + j2;
                    for (int l2 = 0; l2 < n2; ++l2) {
                        s2 += dFdYi[l2] * z[zIndex];
                        zIndex += n2;
                    }
                    zDot[startIndex + i2 * n2] = s2;
                }
            }
            for (i2 = 0; i2 < n2; ++i2) {
                dFdYi = this.dFdY[i2];
                double[] dFdPi = this.dFdP[i2];
                for (int j3 = 0; j3 < k2; ++j3) {
                    int startIndex;
                    double s3 = dFdPi[j3];
                    int zIndex = startIndex = n2 * (n2 + 1) + j3;
                    for (int l3 = 0; l3 < n2; ++l3) {
                        s3 += dFdYi[l3] * z[zIndex];
                        zIndex += k2;
                    }
                    zDot[startIndex + i2 * k2] = s3;
                }
            }
        }
    }
}

