/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.CholeskyDecomposition;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.NotSymmetricMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.FastMath;

public class CholeskyDecompositionImpl
implements CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecompositionImpl(RealMatrix matrix) throws NonSquareMatrixException, NotSymmetricMatrixException, NotPositiveDefiniteMatrixException {
        this(matrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecompositionImpl(RealMatrix matrix, double relativeSymmetryThreshold, double absolutePositivityThreshold) throws NonSquareMatrixException, NotSymmetricMatrixException, NotPositiveDefiniteMatrixException {
        int i2;
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        this.lTData = matrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        for (i2 = 0; i2 < order; ++i2) {
            double[] lI = this.lTData[i2];
            for (int j2 = i2 + 1; j2 < order; ++j2) {
                double[] lJ = this.lTData[j2];
                double lIJ = lI[j2];
                double lJI = lJ[i2];
                double maxDelta = relativeSymmetryThreshold * FastMath.max(FastMath.abs(lIJ), FastMath.abs(lJI));
                if (FastMath.abs(lIJ - lJI) > maxDelta) {
                    throw new NotSymmetricMatrixException();
                }
                lJ[i2] = 0.0;
            }
        }
        for (i2 = 0; i2 < order; ++i2) {
            double[] ltI = this.lTData[i2];
            if (ltI[i2] < absolutePositivityThreshold) {
                throw new NotPositiveDefiniteMatrixException();
            }
            ltI[i2] = FastMath.sqrt(ltI[i2]);
            double inverse = 1.0 / ltI[i2];
            for (int q2 = order - 1; q2 > i2; --q2) {
                int n2 = q2;
                ltI[n2] = ltI[n2] * inverse;
                double[] ltQ = this.lTData[q2];
                for (int p2 = q2; p2 < order; ++p2) {
                    int n3 = p2;
                    ltQ[n3] = ltQ[n3] - ltI[q2] * ltI[p2];
                }
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (int i2 = 0; i2 < this.lTData.length; ++i2) {
            double lTii = this.lTData[i2][i2];
            determinant *= lTii * lTii;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lTData);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lTData;

        private Solver(double[][] lTData) {
            this.lTData = lTData;
        }

        public boolean isNonSingular() {
            return true;
        }

        public double[] solve(double[] b2) throws IllegalArgumentException, InvalidMatrixException {
            int j2;
            int m2 = this.lTData.length;
            if (b2.length != m2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b2.length, m2);
            }
            double[] x2 = (double[])b2.clone();
            for (j2 = 0; j2 < m2; ++j2) {
                double[] lJ = this.lTData[j2];
                int n2 = j2;
                x2[n2] = x2[n2] / lJ[j2];
                double xJ = x2[j2];
                for (int i2 = j2 + 1; i2 < m2; ++i2) {
                    int n3 = i2;
                    x2[n3] = x2[n3] - xJ * lJ[i2];
                }
            }
            for (j2 = m2 - 1; j2 >= 0; --j2) {
                int n4 = j2;
                x2[n4] = x2[n4] / this.lTData[j2][j2];
                double xJ = x2[j2];
                for (int i3 = 0; i3 < j2; ++i3) {
                    int n5 = i3;
                    x2[n5] = x2[n5] - xJ * this.lTData[i3][j2];
                }
            }
            return x2;
        }

        public RealVector solve(RealVector b2) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayRealVector)b2);
            }
            catch (ClassCastException cce) {
                int j2;
                int m2 = this.lTData.length;
                if (b2.getDimension() != m2) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b2.getDimension(), m2);
                }
                double[] x2 = b2.getData();
                for (j2 = 0; j2 < m2; ++j2) {
                    double[] lJ = this.lTData[j2];
                    int n2 = j2;
                    x2[n2] = x2[n2] / lJ[j2];
                    double xJ = x2[j2];
                    for (int i2 = j2 + 1; i2 < m2; ++i2) {
                        int n3 = i2;
                        x2[n3] = x2[n3] - xJ * lJ[i2];
                    }
                }
                for (j2 = m2 - 1; j2 >= 0; --j2) {
                    int n4 = j2;
                    x2[n4] = x2[n4] / this.lTData[j2][j2];
                    double xJ = x2[j2];
                    for (int i3 = 0; i3 < j2; ++i3) {
                        int n5 = i3;
                        x2[n5] = x2[n5] - xJ * this.lTData[i3][j2];
                    }
                }
                return new ArrayRealVector(x2, false);
            }
        }

        public ArrayRealVector solve(ArrayRealVector b2) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayRealVector(this.solve(b2.getDataRef()), false);
        }

        public RealMatrix solve(RealMatrix b2) throws IllegalArgumentException, InvalidMatrixException {
            int j2;
            int m2 = this.lTData.length;
            if (b2.getRowDimension() != m2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b2.getRowDimension(), b2.getColumnDimension(), m2, "n");
            }
            int nColB = b2.getColumnDimension();
            double[][] x2 = b2.getData();
            for (j2 = 0; j2 < m2; ++j2) {
                double[] lJ = this.lTData[j2];
                double lJJ = lJ[j2];
                double[] xJ = x2[j2];
                int k2 = 0;
                while (k2 < nColB) {
                    int n2 = k2++;
                    xJ[n2] = xJ[n2] / lJJ;
                }
                for (int i2 = j2 + 1; i2 < m2; ++i2) {
                    double[] xI = x2[i2];
                    double lJI = lJ[i2];
                    for (int k3 = 0; k3 < nColB; ++k3) {
                        int n3 = k3;
                        xI[n3] = xI[n3] - xJ[k3] * lJI;
                    }
                }
            }
            for (j2 = m2 - 1; j2 >= 0; --j2) {
                double lJJ = this.lTData[j2][j2];
                double[] xJ = x2[j2];
                int k4 = 0;
                while (k4 < nColB) {
                    int n4 = k4++;
                    xJ[n4] = xJ[n4] / lJJ;
                }
                for (int i3 = 0; i3 < j2; ++i3) {
                    double[] xI = x2[i3];
                    double lIJ = this.lTData[i3][j2];
                    for (int k5 = 0; k5 < nColB; ++k5) {
                        int n5 = k5;
                        xI[n5] = xI[n5] - xJ[k5] * lIJ;
                    }
                }
            }
            return new Array2DRowRealMatrix(x2, false);
        }

        public RealMatrix getInverse() throws InvalidMatrixException {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.lTData.length));
        }
    }
}

