/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.FastMath;

public class TDistributionImpl
extends AbstractContinuousDistribution
implements TDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public TDistributionImpl(double degreesOfFreedom, double inverseCumAccuracy) {
        this.setDegreesOfFreedomInternal(degreesOfFreedom);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public TDistributionImpl(double degreesOfFreedom) {
        this(degreesOfFreedom, 1.0E-9);
    }

    @Deprecated
    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.setDegreesOfFreedomInternal(degreesOfFreedom);
    }

    private void setDegreesOfFreedomInternal(double newDegreesOfFreedom) {
        if (newDegreesOfFreedom <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_DEGREES_OF_FREEDOM, newDegreesOfFreedom);
        }
        this.degreesOfFreedom = newDegreesOfFreedom;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public double density(double x2) {
        double n2 = this.degreesOfFreedom;
        double nPlus1Over2 = (n2 + 1.0) / 2.0;
        return FastMath.exp(Gamma.logGamma(nPlus1Over2) - 0.5 * (FastMath.log(Math.PI) + FastMath.log(n2)) - Gamma.logGamma(n2 / 2.0) - nPlus1Over2 * FastMath.log(1.0 + x2 * x2 / n2));
    }

    public double cumulativeProbability(double x2) throws MathException {
        double ret;
        if (x2 == 0.0) {
            ret = 0.5;
        } else {
            double t2 = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + x2 * x2), 0.5 * this.degreesOfFreedom, 0.5);
            ret = x2 < 0.0 ? 0.5 * t2 : 1.0 - 0.5 * t2;
        }
        return ret;
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p2);
    }

    protected double getDomainLowerBound(double p2) {
        return -1.7976931348623157E308;
    }

    protected double getDomainUpperBound(double p2) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p2) {
        return 0.0;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalMean() {
        double df = this.getDegreesOfFreedom();
        if (df > 1.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    public double getNumericalVariance() {
        double df = this.getDegreesOfFreedom();
        if (df > 2.0) {
            return df / (df - 2.0);
        }
        if (df > 1.0 && df <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }
}

