/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MetricsFile<BEAN extends MetricBase, HKEY extends Comparable> {
    public static final String MAJOR_HEADER_PREFIX = "## ";
    public static final String MINOR_HEADER_PREFIX = "# ";
    public static final String SEPARATOR = "\t";
    public static final String HISTO_HEADER = "## HISTOGRAM\t";
    public static final String METRIC_HEADER = "## METRICS CLASS\t";
    private final Set<String> columnLabels = new HashSet<String>();
    private final List<Header> headers = new ArrayList<Header>();
    private final List<BEAN> metrics = new ArrayList<BEAN>();
    private final List<Histogram<HKEY>> histograms = new ArrayList<Histogram<HKEY>>();

    public void addHeader(Header h2) {
        this.headers.add(h2);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addMetric(BEAN bean) {
        this.metrics.add(bean);
    }

    public void addAllMetrics(Iterable<BEAN> beanz) {
        for (MetricBase bean : beanz) {
            this.addMetric(bean);
        }
    }

    public List<BEAN> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public Set<String> getMetricsColumnLabels() {
        return Collections.unmodifiableSet(this.columnLabels);
    }

    public Histogram<HKEY> getHistogram() {
        if (this.histograms.size() > 0) {
            return this.histograms.get(0);
        }
        return null;
    }

    public void setHistogram(Histogram<HKEY> histogram) {
        if (this.histograms.isEmpty()) {
            if (histogram != null) {
                this.histograms.add(histogram);
            }
        } else {
            this.histograms.set(0, histogram);
        }
    }

    public void addHistogram(Histogram<HKEY> histogram) {
        this.histograms.add(histogram);
    }

    public List<Histogram<HKEY>> getAllHistograms() {
        return Collections.unmodifiableList(this.histograms);
    }

    public int getNumHistograms() {
        return this.histograms.size();
    }

    public List<Header> getHeaders(Class<? extends Header> type) {
        ArrayList<Header> tmp = new ArrayList<Header>();
        for (Header h2 : this.headers) {
            if (!h2.getClass().equals(type)) continue;
            tmp.add(h2);
        }
        return tmp;
    }

    public void write(File f2) {
        FileWriter w2 = null;
        try {
            w2 = new FileWriter(f2);
            this.write(w2);
        }
        catch (IOException ioe) {
            throw new SAMException("Could not write metrics to file: " + f2.getAbsolutePath(), ioe);
        }
        finally {
            if (w2 != null) {
                try {
                    w2.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    public void write(Writer w2) {
        try {
            FormatUtil formatter = new FormatUtil();
            BufferedWriter out = new BufferedWriter(w2);
            this.printHeaders(out);
            out.newLine();
            this.printBeanMetrics(out, formatter);
            out.newLine();
            this.printHistogram(out, formatter);
            out.newLine();
            out.flush();
        }
        catch (IOException ioe) {
            throw new SAMException("Could not write metrics file.", ioe);
        }
    }

    private void printHeaders(BufferedWriter out) throws IOException {
        for (Header h2 : this.headers) {
            out.append(MAJOR_HEADER_PREFIX);
            out.append(h2.getClass().getName());
            out.newLine();
            out.append(MINOR_HEADER_PREFIX);
            out.append(((Object)h2).toString());
            out.newLine();
        }
    }

    private void printBeanMetrics(BufferedWriter out, FormatUtil formatter) throws IOException {
        if (this.metrics.isEmpty()) {
            return;
        }
        out.append(METRIC_HEADER + this.getBeanType().getName());
        out.newLine();
        Field[] fields = this.getBeanType().getFields();
        int fieldCount = fields.length;
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            out.append(fields[i2].getName());
            if (i2 < fieldCount - 1) {
                out.append(SEPARATOR);
                continue;
            }
            out.newLine();
        }
        for (MetricBase bean : this.metrics) {
            for (int i3 = 0; i3 < fieldCount; ++i3) {
                try {
                    Object value = fields[i3].get(bean);
                    out.append(StringUtil.assertCharactersNotInString(formatter.format(value), '\t', '\n'));
                    if (i3 < fieldCount - 1) {
                        out.append(SEPARATOR);
                        continue;
                    }
                    out.newLine();
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new SAMException("Could not read property " + fields[i3].getName() + " from class of type " + bean.getClass());
                }
            }
        }
        out.flush();
    }

    private void printHistogram(BufferedWriter out, FormatUtil formatter) throws IOException {
        ArrayList<Histogram<HKEY>> nonEmptyHistograms = new ArrayList<Histogram<HKEY>>();
        for (Histogram<HKEY> histo : this.histograms) {
            if (histo.isEmpty()) continue;
            nonEmptyHistograms.add(histo);
        }
        if (nonEmptyHistograms.isEmpty()) {
            return;
        }
        TreeSet keys = new TreeSet(((Histogram)nonEmptyHistograms.get(0)).comparator());
        for (Histogram histogram : nonEmptyHistograms) {
            if (histogram == null) continue;
            keys.addAll(histogram.keySet());
        }
        out.append(HISTO_HEADER + ((Comparable)((Histogram)nonEmptyHistograms.get(0)).keySet().iterator().next()).getClass().getName());
        out.newLine();
        out.append(StringUtil.assertCharactersNotInString(((Histogram)nonEmptyHistograms.get(0)).getBinLabel(), '\t', '\n'));
        for (Histogram histogram : nonEmptyHistograms) {
            out.append(SEPARATOR);
            out.append(StringUtil.assertCharactersNotInString(histogram.getValueLabel(), '\t', '\n'));
        }
        out.newLine();
        for (Comparable comparable : keys) {
            out.append(comparable.toString());
            for (Histogram histogram : nonEmptyHistograms) {
                Histogram.Bin bin = (Histogram.Bin)histogram.get(comparable);
                double value = bin == null ? 0.0 : bin.getValue();
                out.append(SEPARATOR);
                out.append(formatter.format(value));
            }
            out.newLine();
        }
    }

    private Class<?> getBeanType() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        return ((MetricBase)this.metrics.get(0)).getClass();
    }

    public void read(Reader r2) {
        block32: {
            BufferedReader in = new BufferedReader(r2);
            FormatUtil formatter = new FormatUtil();
            String line = null;
            try {
                String className;
                Header header = null;
                while ((line = in.readLine()) != null) {
                    if ("".equals(line = line.trim())) continue;
                    if (line.startsWith(METRIC_HEADER) || line.startsWith(HISTO_HEADER)) break;
                    if (line.startsWith(MAJOR_HEADER_PREFIX)) {
                        if (header != null) {
                            throw new IllegalStateException("Consecutive header class lines encountered.");
                        }
                        className = line.substring(MAJOR_HEADER_PREFIX.length()).trim();
                        try {
                            header = (Header)this.loadClass(className, true).newInstance();
                            continue;
                        }
                        catch (Exception e2) {
                            throw new SAMException("Error load and/or instantiating an instance of " + className, e2);
                        }
                    }
                    if (line.startsWith(MINOR_HEADER_PREFIX)) {
                        if (header == null) {
                            throw new IllegalStateException("Header class must precede header value:" + line);
                        }
                        header.parse(line.substring(MINOR_HEADER_PREFIX.length()));
                        this.headers.add(header);
                        header = null;
                        continue;
                    }
                    throw new SAMException("Illegal state. Found following string in metrics file header: " + line);
                }
                while (line != null && !line.trim().startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line != null && (line = line.trim()).startsWith(METRIC_HEADER)) {
                    className = line.split(SEPARATOR)[1];
                    Class<?> type = null;
                    try {
                        type = this.loadClass(className, true);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SAMException("Could not locate class with name " + className, cnfe);
                    }
                    String[] fieldNames = in.readLine().split(SEPARATOR);
                    Collections.addAll(this.columnLabels, fieldNames);
                    Field[] fields = new Field[fieldNames.length];
                    for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                        try {
                            fields[i2] = type.getField(fieldNames[i2]);
                            continue;
                        }
                        catch (Exception e3) {
                            throw new SAMException("Could not get field with name " + fieldNames[i2] + " from class " + type.getName());
                        }
                    }
                    while ((line = in.readLine()) != null && !"".equals(line.trim())) {
                        String[] values = line.split(SEPARATOR, -1);
                        MetricBase bean = null;
                        try {
                            bean = (MetricBase)type.newInstance();
                        }
                        catch (Exception e4) {
                            throw new SAMException("Error instantiating a " + type.getName(), e4);
                        }
                        for (int i3 = 0; i3 < fields.length; ++i3) {
                            Object value = null;
                            if (values[i3] != null && values[i3].length() > 0) {
                                value = formatter.parseObject(values[i3], fields[i3].getType());
                            }
                            try {
                                fields[i3].set(bean, value);
                                continue;
                            }
                            catch (Exception e5) {
                                throw new SAMException("Error setting field " + fields[i3].getName() + " on class of type " + type.getName(), e5);
                            }
                        }
                        this.metrics.add(bean);
                    }
                }
                while (line != null && !line.trim().startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line == null || !(line = line.trim()).startsWith(HISTO_HEADER)) break block32;
                String keyClassName = line.split(SEPARATOR)[1].trim();
                Class<?> keyClass = null;
                try {
                    keyClass = this.loadClass(keyClassName, true);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SAMException("Could not load class with name " + keyClassName);
                }
                String[] labels = in.readLine().split(SEPARATOR);
                for (int i4 = 1; i4 < labels.length; ++i4) {
                    this.histograms.add(new Histogram(labels[0], labels[i4]));
                }
                while ((line = in.readLine()) != null && !"".equals(line)) {
                    String[] fields = line.trim().split(SEPARATOR);
                    Comparable key = (Comparable)formatter.parseObject(fields[0], keyClass);
                    for (int i5 = 1; i5 < fields.length; ++i5) {
                        double value = formatter.parseDouble(fields[i5]);
                        this.histograms.get(i5 - 1).increment(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                throw new SAMException("Could not read metrics from reader.", ioe);
            }
            finally {
                CloserUtil.close(in);
            }
        }
    }

    private Class<?> loadClass(String className, boolean tryOtherPackages) throws ClassNotFoundException {
        String[] packages = new String[]{"edu.mit.broad.picard.genotype.concordance", "edu.mit.broad.picard.genotype.fingerprint", "edu.mit.broad.picard.ic", "edu.mit.broad.picard.illumina", "edu.mit.broad.picard.jumping", "edu.mit.broad.picard.quality", "edu.mit.broad.picard.samplevalidation", "htsjdk.samtools.analysis", "htsjdk.samtools.analysis.directed", "htsjdk.samtools.sam", "htsjdk.samtools.metrics", "picard.sam", "picard.metrics", "picard.illumina", "picard.analysis", "picard.analysis.directed", "picard.vcf"};
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (tryOtherPackages) {
                for (String p2 : packages) {
                    try {
                        return this.loadClass(p2 + className.substring(className.lastIndexOf(".")), false);
                    }
                    catch (ClassNotFoundException cnf2) {
                        if (className.indexOf("$") <= -1) continue;
                        try {
                            return this.loadClass(p2 + "." + className.substring(className.lastIndexOf("$") + 1), false);
                        }
                        catch (ClassNotFoundException cnf22) {
                            // empty catch block
                        }
                    }
                }
            }
            throw cnfe;
        }
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (this.getClass() != o2.getClass()) {
            return false;
        }
        MetricsFile that = (MetricsFile)o2;
        if (!this.areHeadersEqual(that)) {
            return false;
        }
        if (!this.areMetricsEqual(that)) {
            return false;
        }
        return this.areHistogramsEqual(that);
    }

    public boolean areHeadersEqual(MetricsFile that) {
        return ((Object)this.headers).equals(that.headers);
    }

    public boolean areMetricsEqual(MetricsFile that) {
        return ((Object)this.metrics).equals(that.metrics);
    }

    public boolean areHistogramsEqual(MetricsFile that) {
        return ((Object)this.histograms).equals(that.histograms);
    }

    public int hashCode() {
        int result = ((Object)this.headers).hashCode();
        result = 31 * result + ((Object)this.metrics).hashCode();
        return result;
    }

    public static List<? extends MetricBase> readBeans(File file) {
        try {
            MetricsFile metricsFile = new MetricsFile();
            metricsFile.read(new FileReader(file));
            return metricsFile.getMetrics();
        }
        catch (FileNotFoundException e2) {
            throw new SAMException(e2.getMessage(), e2);
        }
    }

    public static List<Header> readHeaders(File file) {
        try {
            MetricsFile metricsFile = new MetricsFile();
            metricsFile.read(new FileReader(file));
            return metricsFile.getHeaders();
        }
        catch (FileNotFoundException e2) {
            throw new SAMException(e2.getMessage(), e2);
        }
    }

    public static boolean areMetricsEqual(File file1, File file2) {
        try {
            MetricsFile mf1 = new MetricsFile();
            MetricsFile mf2 = new MetricsFile();
            mf1.read(new FileReader(file1));
            mf2.read(new FileReader(file2));
            return mf1.areMetricsEqual(mf2);
        }
        catch (FileNotFoundException e2) {
            throw new SAMException(e2.getMessage(), e2);
        }
    }
}

