/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.Slice;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class SliceIO {
    public void readSliceHeadBlock(Slice s2, InputStream is) throws IOException {
        s2.headerBlock = new Block(is, true, true);
        this.parseSliceHeaderBlock(s2);
    }

    public void parseSliceHeaderBlock(Slice s2) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(s2.headerBlock.getRawContent());
        s2.sequenceId = ByteBufferUtils.readUnsignedITF8(is);
        s2.alignmentStart = ByteBufferUtils.readUnsignedITF8(is);
        s2.alignmentSpan = ByteBufferUtils.readUnsignedITF8(is);
        s2.nofRecords = ByteBufferUtils.readUnsignedITF8(is);
        s2.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(is);
        s2.nofBlocks = ByteBufferUtils.readUnsignedITF8(is);
        s2.contentIDs = ByteBufferUtils.array(is);
        s2.embeddedRefBlockContentID = ByteBufferUtils.readUnsignedITF8(is);
        s2.refMD5 = new byte[16];
        ByteBufferUtils.readFully(s2.refMD5, is);
    }

    public byte[] createSliceHeaderBlockContent(Slice s2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBufferUtils.writeUnsignedITF8(s2.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.alignmentStart, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.alignmentSpan, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.nofRecords, baos);
        ByteBufferUtils.writeUnsignedLTF8(s2.globalRecordCounter, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.nofBlocks, baos);
        s2.contentIDs = new int[s2.external.size()];
        int i2 = 0;
        for (int id : s2.external.keySet()) {
            s2.contentIDs[i2++] = id;
        }
        ByteBufferUtils.write(s2.contentIDs, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.embeddedRefBlockContentID, baos);
        baos.write(s2.refMD5 == null ? new byte[16] : s2.refMD5);
        ByteBufferUtils.writeUnsignedITF8(s2.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s2.sequenceId, baos);
        return baos.toByteArray();
    }

    public void createSliceHeaderBlock(Slice s2) throws IOException {
        byte[] rawContent = this.createSliceHeaderBlockContent(s2);
        s2.headerBlock = new Block(BlockCompressionMethod.RAW, BlockContentType.MAPPED_SLICE, 0, rawContent, null);
    }

    public void readSliceBlocks(Slice s2, boolean uncompressBlocks, InputStream is) throws IOException {
        s2.external = new HashMap<Integer, Block>();
        block4: for (int i2 = 0; i2 < s2.nofBlocks; ++i2) {
            Block b1 = new Block(is, true, uncompressBlocks);
            switch (b1.contentType) {
                case CORE: {
                    s2.coreBlock = b1;
                    continue block4;
                }
                case EXTERNAL: {
                    if (s2.embeddedRefBlockContentID == b1.contentId) {
                        s2.embeddedRefBlock = b1;
                    }
                    s2.external.put(b1.contentId, b1);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + b1.contentType.name());
                }
            }
        }
    }

    public void write(Slice s2, OutputStream os) throws IOException {
        s2.nofBlocks = 1 + s2.external.size() + (s2.embeddedRefBlock == null ? 0 : 1);
        s2.contentIDs = new int[s2.external.size()];
        int i2 = 0;
        Iterator<Integer> i$ = s2.external.keySet().iterator();
        while (i$.hasNext()) {
            int id;
            s2.contentIDs[i2] = id = i$.next().intValue();
        }
        this.createSliceHeaderBlock(s2);
        s2.headerBlock.write(os);
        s2.coreBlock.write(os);
        for (Block e2 : s2.external.values()) {
            e2.write(os);
        }
    }

    public void read(Slice s2, InputStream is) throws IOException {
        this.readSliceHeadBlock(s2, is);
        this.readSliceBlocks(s2, true, is);
    }
}

