/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DataWriterFactory {
    public Writer buildWriter(BitOutputStream bos, Map<Integer, ExposedByteArrayOutputStream> outputMap, CompressionHeader h2, int refId) throws IllegalArgumentException, IllegalAccessException {
        Writer writer = new Writer();
        writer.captureReadNames = h2.readNamesIncluded;
        writer.refId = refId;
        writer.substitutionMatrix = h2.substitutionMatrix;
        writer.AP_delta = h2.AP_seriesDelta;
        for (Field f2 : writer.getClass().getFields()) {
            DataSeriesMap dsm;
            String name;
            if (f2.isAnnotationPresent(DataSeries.class)) {
                DataSeries ds = f2.getAnnotation(DataSeries.class);
                EncodingKey key = ds.key();
                DataSeriesType type = ds.type();
                f2.set(writer, this.createWriter(type, h2.eMap.get((Object)key), bos, outputMap));
            }
            if (!f2.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(name = (dsm = f2.getAnnotation(DataSeriesMap.class)).name())) continue;
            HashMap map = new HashMap();
            for (Integer key : h2.tMap.keySet()) {
                EncodingParams params = h2.tMap.get(key);
                DataWriter tagWtiter = this.createWriter(DataSeriesType.BYTE_ARRAY, params, bos, outputMap);
                map.put(key, tagWtiter);
            }
            f2.set(writer, map);
        }
        return writer;
    }

    private <T> DataWriter<T> createWriter(DataSeriesType valueType2, EncodingParams params, BitOutputStream bos, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        EncodingFactory f2 = new EncodingFactory();
        Encoding encoding = f2.createEncoding(valueType2, params.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found: value type=" + valueType2.name() + ", encoding id=" + params.id.name());
        }
        encoding.fromByteArray(params.params);
        return new DefaultDataWriter(encoding.buildCodec(null, outputMap), bos);
    }

    private static class DefaultDataWriter<T>
    implements DataWriter<T> {
        private BitCodec<T> codec;
        private BitOutputStream bos;

        public DefaultDataWriter(BitCodec<T> codec, BitOutputStream bos) {
            this.codec = codec;
            this.bos = bos;
        }

        @Override
        public long writeData(T value) throws IOException {
            return this.codec.write(this.bos, value);
        }
    }
}

