/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.io.IOException;
import java.util.LinkedList;

public class CramRecordReader
extends AbstractReader {
    private CramCompressionRecord prevRecord;

    public void read(CramCompressionRecord r2) throws IOException {
        try {
            int i2;
            r2.flags = (Integer)this.bitFlagsC.readData();
            r2.compressionFlags = ((Byte)this.compBitFlagsC.readData()).byteValue();
            r2.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            r2.readLength = (Integer)this.readLengthC.readData();
            if (this.AP_delta) {
                r2.alignmentDelta = (Integer)this.alStartC.readData();
            } else {
                r2.alignmentStart = (Integer)this.alStartC.readData();
            }
            r2.readGroupID = (Integer)this.readGroupC.readData();
            if (this.captureReadNames) {
                r2.readName = new String((byte[])this.readNameC.readData(), this.charset);
            }
            if (r2.isDetached()) {
                r2.mateFlags = ((Byte)this.mbfc.readData()).byteValue();
                if (!this.captureReadNames) {
                    r2.readName = new String((byte[])this.readNameC.readData(), this.charset);
                }
                r2.mateSequenceID = (Integer)this.mrc.readData();
                r2.mateAlignmentStart = (Integer)this.malsc.readData();
                r2.templateSize = (Integer)this.tsc.readData();
                ++detachedCount;
            } else if (r2.isHasMateDownStream()) {
                r2.recordsToNextFragment = (Integer)this.distanceC.readData();
            }
            Integer tagIdList = (Integer)this.tagIdListCodec.readData();
            byte[][] ids = this.tagIdDictionary[tagIdList];
            if (ids.length > 0) {
                int tagCount = ids.length;
                r2.tags = new ReadTag[tagCount];
                for (i2 = 0; i2 < ids.length; ++i2) {
                    ReadTag tag;
                    int id = ReadTag.name3BytesToInt(ids[i2]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(id);
                    byte[] data = null;
                    data = (byte[])dataReader.readData();
                    r2.tags[i2] = tag = new ReadTag(id, data);
                }
            }
            if (!r2.isSegmentUnmapped()) {
                int size = (Integer)this.nfc.readData();
                int prevPos = 0;
                LinkedList<ReadFeature> rf = new LinkedList<ReadFeature>();
                r2.readFeatures = rf;
                block17: for (int i3 = 0; i3 < size; ++i3) {
                    int pos;
                    Byte operator = (Byte)this.fc.readData();
                    prevPos = pos = prevPos + (Integer)this.fp.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase rb = new ReadBase(pos, (Byte)this.bc.readData(), (Byte)this.qc.readData());
                            rf.add(rb);
                            continue block17;
                        }
                        case 88: {
                            Substitution sv = new Substitution();
                            sv.setPosition(pos);
                            byte code = (Byte)this.bsc.readData();
                            sv.setCode(code);
                            rf.add(sv);
                            continue block17;
                        }
                        case 73: {
                            Insertion iv = new Insertion(pos, (byte[])this.inc.readData());
                            rf.add(iv);
                            continue block17;
                        }
                        case 83: {
                            SoftClip fv = new SoftClip(pos, (byte[])this.softClipCodec.readData());
                            rf.add(fv);
                            continue block17;
                        }
                        case 72: {
                            HardClip hv = new HardClip(pos, (Integer)this.hardClipCodec.readData());
                            rf.add(hv);
                            continue block17;
                        }
                        case 80: {
                            Padding pv = new Padding(pos, (Integer)this.dlc.readData());
                            rf.add(pv);
                            continue block17;
                        }
                        case 68: {
                            Deletion dv = new Deletion(pos, (Integer)this.dlc.readData());
                            rf.add(dv);
                            continue block17;
                        }
                        case 78: {
                            RefSkip rsv = new RefSkip(pos, (Integer)this.refSkipCodec.readData());
                            rf.add(rsv);
                            continue block17;
                        }
                        case 105: {
                            InsertBase ib = new InsertBase(pos, (Byte)this.bc.readData());
                            rf.add(ib);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore bqs = new BaseQualityScore(pos, (Byte)this.qc.readData());
                            rf.add(bqs);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                }
                r2.mappingQuality = (Integer)this.mqc.readData();
                if (r2.isForcePreserveQualityScores()) {
                    byte[] qs = (byte[])this.qcArray.readDataArray(r2.readLength);
                    r2.qualityScores = qs;
                }
            } else {
                byte[] bases = new byte[r2.readLength];
                for (i2 = 0; i2 < bases.length; ++i2) {
                    bases[i2] = (Byte)this.bc.readData();
                }
                r2.readBases = bases;
                if (r2.isForcePreserveQualityScores()) {
                    byte[] qs = (byte[])this.qcArray.readDataArray(r2.readLength);
                    r2.qualityScores = qs;
                }
            }
            ++this.recordCounter;
            this.prevRecord = r2;
        }
        catch (Exception e2) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeException(e2);
        }
    }
}

