/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteArrayLenEncoding
implements Encoding<byte[]> {
    public static final EncodingID ID = EncodingID.BYTE_ARRAY_LEN;
    Encoding<Integer> lenEncoding;
    Encoding<byte[]> byteEncoding;

    @Override
    public EncodingID id() {
        return ID;
    }

    public static EncodingParams toParam(EncodingParams lenParams, EncodingParams byteParams) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write((byte)lenParams.id.ordinal());
            ByteBufferUtils.writeUnsignedITF8(lenParams.params.length, baos);
            baos.write(lenParams.params);
            baos.write((byte)byteParams.id.ordinal());
            ByteBufferUtils.writeUnsignedITF8(byteParams.params.length, baos);
            baos.write(byteParams.params);
        }
        catch (IOException e2) {
            throw new RuntimeException("It never happened. ");
        }
        return new EncodingParams(ID, baos.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write((byte)this.lenEncoding.id().ordinal());
            byte[] lenBytes = this.lenEncoding.toByteArray();
            ByteBufferUtils.writeUnsignedITF8(lenBytes.length, baos);
            baos.write(lenBytes);
            baos.write((byte)this.byteEncoding.id().ordinal());
            byte[] byteBytes = this.byteEncoding.toByteArray();
            ByteBufferUtils.writeUnsignedITF8(byteBytes.length, baos);
            baos.write(byteBytes);
        }
        catch (IOException e2) {
            throw new RuntimeException("It never happened. ");
        }
        return baos.toByteArray();
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        EncodingFactory f2 = new EncodingFactory();
        EncodingID lenID = EncodingID.values()[buf.get()];
        this.lenEncoding = f2.createEncoding(DataSeriesType.INT, lenID);
        int len = ByteBufferUtils.readUnsignedITF8(buf);
        byte[] bytes = new byte[len];
        buf.get(bytes);
        this.lenEncoding.fromByteArray(bytes);
        EncodingID byteID = EncodingID.values()[buf.get()];
        this.byteEncoding = f2.createEncoding(DataSeriesType.BYTE_ARRAY, byteID);
        len = ByteBufferUtils.readUnsignedITF8(buf);
        bytes = new byte[len];
        buf.get(bytes);
        this.byteEncoding.fromByteArray(bytes);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new ByteArrayLenCodec(this.lenEncoding.buildCodec(inputMap, outputMap), this.byteEncoding.buildCodec(inputMap, outputMap));
    }

    private static class ByteArrayLenCodec
    extends AbstractBitCodec<byte[]> {
        private BitCodec<Integer> lenCodec;
        private BitCodec<byte[]> byteCodec;

        public ByteArrayLenCodec(BitCodec<Integer> lenCodec, BitCodec<byte[]> byteCodec) {
            this.lenCodec = lenCodec;
            this.byteCodec = byteCodec;
        }

        @Override
        public byte[] read(BitInputStream bis) throws IOException {
            int len = this.lenCodec.read(bis);
            return this.byteCodec.read(bis, len);
        }

        @Override
        public byte[] read(BitInputStream bis, int len) throws IOException {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public long write(BitOutputStream bos, byte[] object) throws IOException {
            long len = this.lenCodec.write(bos, object.length);
            return len += this.byteCodec.write(bos, object);
        }

        @Override
        public long numberOfBits(byte[] object) {
            return this.lenCodec.numberOfBits(object.length) + this.byteCodec.numberOfBits(object);
        }
    }
}

