/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CRAMFileReader
extends SamReader.ReaderImplementation {
    private File file;
    private final ReferenceSource referenceSource;
    private InputStream is;
    private CRAMIterator it;
    private BAMIndex mIndex;
    private File mIndexFile;
    private boolean mEnableIndexCaching;
    private boolean mEnableIndexMemoryMapping;
    private ValidationStringency validationStringency;
    private static final SAMRecordIterator emptyIterator = new SAMRecordIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new RuntimeException("No records.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported.");
        }

        @Override
        public void close() {
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this;
        }
    };

    public CRAMFileReader(File file, InputStream is) {
        this(file, is, new ReferenceSource(Defaults.REFERENCE_FASTA));
    }

    public CRAMFileReader(File file, InputStream is, ReferenceSource referenceSource) {
        if (file == null && is == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.file = file;
        this.is = is;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File cramFile, File indexFile, ReferenceSource referenceSource) {
        if (this.file == null) {
            throw new IllegalArgumentException("File is required.");
        }
        this.file = cramFile;
        this.mIndexFile = indexFile;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File file, ReferenceSource referenceSource) {
        if (file == null && this.is == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.file = file;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public SAMRecordIterator iterator() {
        return this.getIterator();
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        this.mEnableIndexCaching = enabled;
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        this.mEnableIndexMemoryMapping = enabled;
    }

    @Override
    void enableCrcChecking(boolean enabled) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
    }

    @Override
    public boolean hasIndex() {
        return this.mIndex != null || this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            SAMSequenceDictionary dictionary = this.getFileHeader().getSequenceDictionary();
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping);
        }
        return this.mIndex;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.it.getSAMFileHeader();
    }

    public SAMRecordIterator getIterator() {
        if (this.it != null && this.file == null) {
            return this.it;
        }
        try {
            CRAMIterator si = this.file != null ? new CRAMIterator(new FileInputStream(this.file), this.referenceSource) : new CRAMIterator(this.is, this.referenceSource);
            si.setValidationStringency(this.validationStringency);
            this.it = si;
            return this.it;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        CRAMIterator si;
        long[] filePointers = null;
        SAMFileHeader fileHeader = this.getFileHeader();
        int referenceIndex = fileHeader.getSequenceIndex(sequence);
        if (referenceIndex != -1) {
            BAMIndex fileIndex = this.getIndex();
            BAMFileSpan fileSpan = fileIndex.getSpanOverlapping(referenceIndex, start, -1);
            long[] lArray = filePointers = fileSpan != null ? fileSpan.toCoordinateArray() : null;
        }
        if (filePointers == null || filePointers.length == 0) {
            return emptyIterator;
        }
        SeekableStream s2 = this.getSeekableStreamOrFailWithRTE();
        try {
            s2.seek(0L);
            si = new CRAMIterator(s2, this.referenceSource);
            si.setValidationStringency(this.validationStringency);
            this.it = si;
        }
        catch (IOException e2) {
            throw new RuntimeEOFException(e2);
        }
        for (int i2 = 0; i2 < filePointers.length; i2 += 2) {
            long containerOffset = filePointers[i2] >>> 16;
            try {
                s2.seek(containerOffset);
                Container c2 = CramIO.readContainerHeader(s2);
                if (c2.alignmentStart + c2.alignmentSpan <= start) continue;
                s2.seek(containerOffset);
                return si;
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        return this.it;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        long startOfLastLinearBin = this.getIndex().getStartOfLastLinearBin();
        SeekableStream s2 = this.getSeekableStreamOrFailWithRTE();
        try {
            s2.seek(0L);
            CRAMIterator si = new CRAMIterator(s2, this.referenceSource);
            si.setValidationStringency(this.validationStringency);
            s2.seek(startOfLastLinearBin);
            this.it = si;
        }
        catch (IOException e2) {
            throw new RuntimeEOFException(e2);
        }
        return this.it;
    }

    private SeekableStream getSeekableStreamOrFailWithRTE() {
        SeekableStream s2 = null;
        if (this.file != null) {
            try {
                s2 = new SeekableFileStream(this.file);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        } else if (this.is instanceof SeekableStream) {
            s2 = (SeekableStream)this.is;
        }
        return s2;
    }

    @Override
    public void close() {
        CloserUtil.close(this.it);
        CloserUtil.close(this.is);
        CloserUtil.close(this.mIndex);
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        if (this.is == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.it != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIndex == null && this.mIndexFile == null) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        throw new SAMException("Multiple interval queries not implemented.");
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.CRAM_TYPE;
    }

    @Override
    void enableFileSource(SamReader reader, boolean enabled) {
        if (this.it != null) {
            this.it.setFileSource(enabled ? reader : null);
        }
    }
}

