/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class TintFilter
extends RGBImageFilter {
    private int _alpha;
    private int _red;
    private int _green;
    private int _blue;
    private int _width;
    private int _height;
    private Insets _insets;

    public TintFilter(Color color, int width, int height, Insets insets) {
        this._alpha = color.getAlpha();
        this._red = color.getRed();
        this._green = color.getGreen();
        this._blue = color.getBlue();
        this._width = width;
        this._height = height;
        this._insets = insets;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x2, int y, int rgb) {
        if (this._insets != null && (x2 < this._insets.left || x2 > this._width - this._insets.right - 1 || y < this._insets.top || y > this._height - this._insets.bottom - 1)) {
            return rgb;
        }
        Color color = new Color(rgb, true);
        int r2 = Math.min(Math.max(color.getRed() + color.getRed() * this._red / 100, 0), 255);
        int g2 = Math.min(Math.max(color.getGreen() + color.getGreen() * this._green / 100, 0), 255);
        int b2 = Math.min(Math.max(color.getBlue() + color.getBlue() * this._blue / 100, 0), 255);
        int a2 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this._alpha / 100, 0), 255);
        return a2 << 24 | r2 << 16 | g2 << 8 | b2;
    }

    public static Image createTintedImage(Image i2, Color color, Insets insets) {
        TintFilter filter = new TintFilter(color, i2.getWidth(null), i2.getHeight(null), insets);
        FilteredImageSource prod = new FilteredImageSource(i2.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

