/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stats;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.Range;
import org.broad.igv.util.collections.IntArrayList;

public class KaplanMeierEstimator {
    static List<Interval> compute(int[] time, boolean[] censured) {
        if (time.length != censured.length) {
            // empty if block
        }
        if (time.length < 2) {
            // empty if block
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        int startTime = 0;
        int endTime = 0;
        for (int i2 = 0; i2 < time.length; ++i2) {
            endTime = time[i2];
            if (censured[i2] || endTime <= startTime) continue;
            intervals.add(new Interval(startTime, endTime));
            startTime = endTime;
        }
        if (endTime > startTime) {
            intervals.add(new Interval(startTime, endTime));
        }
        float atRisk = time.length;
        float cumulativeSurvival = 1.0f;
        Iterator intervalIter = intervals.iterator();
        Interval currentInterval = (Interval)intervalIter.next();
        currentInterval.setCumulativeSurvival(cumulativeSurvival);
        for (int i3 = 0; i3 < time.length; ++i3) {
            int t2 = time[i3];
            if (t2 > currentInterval.getEnd()) {
                float survivors = (atRisk -= (float)currentInterval.getNumberCensured()) - (float)currentInterval.getNumberDied();
                float tmp = survivors / atRisk;
                cumulativeSurvival *= tmp;
                atRisk -= (float)currentInterval.getNumberDied();
                while (intervalIter.hasNext() && t2 > currentInterval.getEnd()) {
                    currentInterval = (Interval)intervalIter.next();
                    currentInterval.setCumulativeSurvival(cumulativeSurvival);
                }
            }
            if (censured[i3]) {
                currentInterval.addCensure(time[i3]);
                continue;
            }
            currentInterval.incDied();
        }
        currentInterval.setCumulativeSurvival(cumulativeSurvival);
        return intervals;
    }

    public static void main(String[] args) {
        int[] survival = new int[]{1, 2, 3, 4, 5, 10, 12};
        boolean[] alive = new boolean[]{false, true, true, false, true, false, true};
        List<Interval> intervals = KaplanMeierEstimator.compute(survival, alive);
        for (Interval i2 : intervals) {
            System.out.println(i2.getStart() + "\t" + i2.getEnd() + "\t" + i2.getNumberDied() + "\t" + i2.getCensored().size() + "\t" + i2.getCumulativeSurvival());
        }
    }

    public static class Interval
    extends Range {
        private int numberDied;
        private IntArrayList censored = new IntArrayList();
        private float cumulativeSurvival;

        public Interval(int start, int end) {
            super(null, start, end);
        }

        void incDied() {
            ++this.numberDied;
        }

        void addCensure(int time) {
            this.censored.add(time);
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNumberDied() {
            return this.numberDied;
        }

        public IntArrayList getCensored() {
            return this.censored;
        }

        public float getCumulativeSurvival() {
            return this.cumulativeSurvival;
        }

        public void setCumulativeSurvival(float cumulativeSurvival) {
            this.cumulativeSurvival = cumulativeSurvival;
        }

        public int getNumberCensured() {
            return this.censored.size();
        }
    }
}

