/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BAMHttpReader
implements AlignmentReader<PicardAlignment> {
    static Logger log = Logger.getLogger(BAMHttpReader.class);
    public static final long oneDay = 86400000L;
    static Hashtable<String, File> indexFileCache = new Hashtable();
    private final ResourceLocator locator;
    URL url;
    SAMFileHeader header;
    SamReader reader;
    List<String> sequenceNames;
    private boolean indexed = false;

    public BAMHttpReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.locator = locator;
        this.url = new URL(locator.getPath());
        this.reader = this.getSamReader(locator, requireIndex);
    }

    public SamReader getSamReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        if (requireIndex) {
            SamReaderFactory factory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
            SeekableStream indexStream = this.getIndexStream(locator.getBamIndexPath());
            this.indexed = true;
            IGVSeekableBufferedStream ss = new IGVSeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(this.url), 128000);
            SamInputResource resource = SamInputResource.of(ss).index(indexStream);
            return factory.open(resource);
        }
        InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
        return new SAMFileReader(new BufferedInputStream(is));
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        if (this.header == null) {
            this.header = this.reader.getFileHeader();
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexed;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            SAMFileHeader header = this.getFileHeader();
            if (header == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>();
            List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
            if (records.size() > 0) {
                for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                    String chr = rec.getSequenceName();
                    this.sequenceNames.add(chr);
                }
            }
        }
        return this.sequenceNames;
    }

    @Override
    public CloseableIterator<PicardAlignment> iterator() {
        try {
            if (this.reader == null) {
                InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
                this.reader = new SAMFileReader(new BufferedInputStream(is));
            }
            return new WrappedIterator(this.reader.iterator());
        }
        catch (IOException e2) {
            log.error("Error creating iterator", e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CloseableIterator<PicardAlignment> query(String sequence, int start, int end, boolean contained) {
        try {
            if (this.reader == null) {
                this.reader = this.getSamReader(this.locator, true);
            }
            SAMRecordIterator iter = this.reader.query(sequence, start + 1, end, contained);
            return new WrappedIterator(iter);
        }
        catch (IOException e2) {
            log.error("Error opening SAM reader", e2);
            throw new RuntimeException("Error opening SAM reader", e2);
        }
    }

    private SeekableStream getIndexStream(String indexPath) throws IOException {
        SeekableStream ss = null;
        URL indexURL = new URL(indexPath);
        boolean foundIndex = false;
        try {
            ss = IGVSeekableStreamFactory.getInstance().getStreamFor(indexURL);
            foundIndex = true;
        }
        catch (FileNotFoundException e2) {
            String newIndexPath = indexPath.replace(".bam.bai", ".bai");
            indexURL = new URL(newIndexPath);
            try {
                ss = IGVSeekableStreamFactory.getInstance().getStreamFor(indexURL);
                foundIndex = true;
            }
            catch (FileNotFoundException e1) {
                foundIndex = false;
            }
        }
        if (!foundIndex) {
            String msg = "Index file not found: " + indexPath;
            throw new DataLoadException(msg, indexPath);
        }
        return ss;
    }
}

