/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.exome;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.exome.ExomeBlock;
import org.broad.igv.feature.exome.ExomeReferenceFrame;

public class ExomeUtils {
    public static List<ExomeReferenceFrame.Gene> collapseToGenes(List<Feature> features) {
        HashMap<String, ExomeReferenceFrame.Gene> genes = new HashMap<String, ExomeReferenceFrame.Gene>(10000);
        for (Feature f2 : features) {
            if (!(f2 instanceof BasicFeature)) continue;
            String geneName = ((BasicFeature)f2).getName();
            ExomeReferenceFrame.Gene gene = (ExomeReferenceFrame.Gene)genes.get(geneName);
            if (gene == null) {
                gene = new ExomeReferenceFrame.Gene((BasicFeature)f2);
                genes.put(geneName, gene);
                continue;
            }
            gene.expand(f2);
        }
        ArrayList<ExomeReferenceFrame.Gene> geneList = new ArrayList<ExomeReferenceFrame.Gene>(genes.values());
        FeatureUtils.sortFeatureList(geneList);
        return geneList;
    }

    static List<ExomeBlock> collapseTranscripts(List<Feature> features) {
        ArrayList<Feature> exons = new ArrayList<Feature>(features.size() * 10);
        for (Feature f2 : features) {
            if (f2 instanceof BasicFeature) {
                List<Exon> tmp = ((BasicFeature)f2).getExons();
                if (tmp != null) {
                    exons.addAll(tmp);
                    continue;
                }
                exons.add(f2);
                continue;
            }
            exons.add(f2);
        }
        FeatureUtils.sortFeatureList(exons);
        List<ExomeBlock> blocks = ExomeUtils.collapseFeatures(exons);
        return blocks;
    }

    private static List<ExomeBlock> collapseFeatures(List<Feature> features) {
        ArrayList<ExomeBlock> blocks = new ArrayList<ExomeBlock>();
        if (features.isEmpty()) {
            return blocks;
        }
        Iterator<Feature> iter = features.iterator();
        Feature f2 = iter.next();
        int blockIndex = 0;
        int exomeStart = 0;
        ExomeBlock block = new ExomeBlock(blockIndex, f2.getStart(), exomeStart, f2.getEnd() - f2.getStart());
        while (iter.hasNext()) {
            f2 = iter.next();
            if (f2.getStart() > block.getGenomeEnd()) {
                blocks.add(block);
                int blockLength = block.getLength();
                int startingLength = f2.getEnd() - f2.getStart();
                block = new ExomeBlock(++blockIndex, f2.getStart(), exomeStart += blockLength, startingLength);
                continue;
            }
            block.extend(f2.getEnd());
        }
        blocks.add(block);
        return blocks;
    }
}

