/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.ArrayPositionMask;
import htsjdk.samtools.cram.mask.PositionMask;
import htsjdk.samtools.cram.mask.ReadMaskFactory;
import htsjdk.samtools.cram.mask.ReadMaskFormatException;
import java.nio.IntBuffer;

public class FastaByteArrayMaskFactory
implements ReadMaskFactory<String> {
    public static final byte DEFAULT_MASK_BYTE = 120;
    public static final byte DEFAULT_NON_MASK_BYTE = 95;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private byte maskByte;
    private IntBuffer buf;

    public FastaByteArrayMaskFactory(byte maskByte, int bufSize) {
        this.maskByte = maskByte;
        this.buf = IntBuffer.allocate(bufSize);
    }

    public FastaByteArrayMaskFactory(byte maskByte) {
        this(maskByte, 1024);
    }

    public FastaByteArrayMaskFactory() {
        this(120, 1024);
    }

    @Override
    public PositionMask createMask(String line) throws ReadMaskFormatException {
        if (line.length() == 0) {
            return ArrayPositionMask.EMPTY_INSTANCE;
        }
        byte[] data = line.getBytes();
        this.buf.clear();
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2] == this.maskByte) {
                this.buf.put(i2 + 1);
                continue;
            }
            if (data[i2] != 10) continue;
            throw new ReadMaskFormatException("New line not allowed inside of mask line: " + line.substring(0, Math.min(10, line.length())));
        }
        this.buf.flip();
        int[] array = new int[this.buf.limit()];
        this.buf.get(array);
        return new ArrayPositionMask(array);
    }
}

