/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class Writer {
    public static final int TEST_MARK = -1599029040;
    public Charset charset = Charset.forName("UTF8");
    public boolean captureReadNames = false;
    @DataSeries(key=EncodingKey.BF_BitFlags, type=DataSeriesType.INT)
    public DataWriter<Integer> bitFlagsC;
    @DataSeries(key=EncodingKey.CF_CompressionBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> compBitFlagsC;
    @DataSeries(key=EncodingKey.RL_ReadLength, type=DataSeriesType.INT)
    public DataWriter<Integer> readLengthC;
    @DataSeries(key=EncodingKey.AP_AlignmentPositionOffset, type=DataSeriesType.INT)
    public DataWriter<Integer> alStartC;
    @DataSeries(key=EncodingKey.RG_ReadGroup, type=DataSeriesType.INT)
    public DataWriter<Integer> readGroupC;
    @DataSeries(key=EncodingKey.RN_ReadName, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> readNameC;
    @DataSeries(key=EncodingKey.NF_RecordsToNextFragment, type=DataSeriesType.INT)
    public DataWriter<Integer> distanceC;
    @DataSeries(key=EncodingKey.TC_TagCount, type=DataSeriesType.BYTE)
    public DataWriter<Byte> tagCountC;
    @DataSeries(key=EncodingKey.TN_TagNameAndType, type=DataSeriesType.INT)
    public DataWriter<Integer> tagNameAndTypeC;
    @DataSeriesMap(name="TAG")
    public Map<Integer, DataWriter<byte[]>> tagValueCodecs;
    @DataSeries(key=EncodingKey.FN_NumberOfReadFeatures, type=DataSeriesType.INT)
    public DataWriter<Integer> nfc;
    @DataSeries(key=EncodingKey.FP_FeaturePosition, type=DataSeriesType.INT)
    public DataWriter<Integer> fp;
    @DataSeries(key=EncodingKey.FC_FeatureCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> fc;
    @DataSeries(key=EncodingKey.BA_Base, type=DataSeriesType.BYTE)
    public DataWriter<Byte> bc;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE)
    public DataWriter<Byte> qc;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> qcArray;
    @DataSeries(key=EncodingKey.BS_BaseSubstitutionCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> bsc;
    @DataSeries(key=EncodingKey.IN_Insertion, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> inc;
    @DataSeries(key=EncodingKey.SC_SoftClip, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> softClipCodec;
    @DataSeries(key=EncodingKey.HC_HardClip, type=DataSeriesType.INT)
    public DataWriter<Integer> hardClipCodec;
    @DataSeries(key=EncodingKey.PD_padding, type=DataSeriesType.INT)
    public DataWriter<Integer> paddingCodec;
    @DataSeries(key=EncodingKey.DL_DeletionLength, type=DataSeriesType.INT)
    public DataWriter<Integer> dlc;
    @DataSeries(key=EncodingKey.MQ_MappingQualityScore, type=DataSeriesType.INT)
    public DataWriter<Integer> mqc;
    @DataSeries(key=EncodingKey.MF_MateBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> mbfc;
    @DataSeries(key=EncodingKey.NS_NextFragmentReferenceSequenceID, type=DataSeriesType.INT)
    public DataWriter<Integer> mrc;
    @DataSeries(key=EncodingKey.NP_NextFragmentAlignmentStart, type=DataSeriesType.INT)
    public DataWriter<Integer> malsc;
    @DataSeries(key=EncodingKey.TS_InsetSize, type=DataSeriesType.INT)
    public DataWriter<Integer> tsc;
    @DataSeries(key=EncodingKey.TM_TestMark, type=DataSeriesType.INT)
    public DataWriter<Integer> testC;
    @DataSeries(key=EncodingKey.TL_TagIdList, type=DataSeriesType.INT)
    public DataWriter<Integer> tagIdListCodec;
    @DataSeries(key=EncodingKey.RI_RefId, type=DataSeriesType.INT)
    public DataWriter<Integer> refIdCodec;
    @DataSeries(key=EncodingKey.RS_RefSkip, type=DataSeriesType.INT)
    public DataWriter<Integer> refSkipCodec;
    public int refId;
    public SubstitutionMatrix substitutionMatrix;
    public boolean AP_delta = true;
    public static int detachedCount = 0;

    public void write(CramCompressionRecord r2) throws IOException {
        this.bitFlagsC.writeData(r2.flags);
        this.compBitFlagsC.writeData(r2.getCompressionFlags());
        if (this.refId == -2) {
            this.refIdCodec.writeData(r2.sequenceId);
        }
        this.readLengthC.writeData(r2.readLength);
        if (this.AP_delta) {
            this.alStartC.writeData(r2.alignmentDelta);
        } else {
            this.alStartC.writeData(r2.alignmentStart);
        }
        this.readGroupC.writeData(r2.readGroupID);
        if (this.captureReadNames) {
            this.readNameC.writeData(r2.readName.getBytes(this.charset));
        }
        if (r2.isDetached()) {
            this.mbfc.writeData(r2.getMateFlags());
            if (!this.captureReadNames) {
                this.readNameC.writeData(r2.readName.getBytes(this.charset));
            }
            this.mrc.writeData(r2.mateSequenceID);
            this.malsc.writeData(r2.mateAlignmentStart);
            this.tsc.writeData(r2.templateSize);
            ++detachedCount;
        } else if (r2.isHasMateDownStream()) {
            this.distanceC.writeData(r2.recordsToNextFragment);
        }
        this.tagIdListCodec.writeData(r2.tagIdsIndex.value);
        if (r2.tags != null) {
            for (int i2 = 0; i2 < r2.tags.length; ++i2) {
                DataWriter<byte[]> writer = this.tagValueCodecs.get(r2.tags[i2].keyType3BytesAsInt);
                writer.writeData(r2.tags[i2].getValueAsByteArray());
            }
        }
        if (!r2.isSegmentUnmapped()) {
            this.nfc.writeData(r2.readFeatures.size());
            int prevPos = 0;
            block16: for (ReadFeature f2 : r2.readFeatures) {
                this.fc.writeData(f2.getOperator());
                switch (f2.getOperator()) {
                    case 88: {
                        break;
                    }
                }
                this.fp.writeData(f2.getPosition() - prevPos);
                prevPos = f2.getPosition();
                switch (f2.getOperator()) {
                    case 66: {
                        ReadBase rb = (ReadBase)f2;
                        this.bc.writeData(rb.getBase());
                        this.qc.writeData(rb.getQualityScore());
                        continue block16;
                    }
                    case 88: {
                        Substitution sv = (Substitution)f2;
                        if (sv.getCode() < 0) {
                            this.bsc.writeData(this.substitutionMatrix.code(sv.getRefernceBase(), sv.getBase()));
                            continue block16;
                        }
                        this.bsc.writeData(sv.getCode());
                        continue block16;
                    }
                    case 73: {
                        Insertion iv = (Insertion)f2;
                        this.inc.writeData(iv.getSequence());
                        continue block16;
                    }
                    case 83: {
                        SoftClip fv = (SoftClip)f2;
                        this.softClipCodec.writeData(fv.getSequence());
                        continue block16;
                    }
                    case 72: {
                        HardClip hv = (HardClip)f2;
                        this.hardClipCodec.writeData(hv.getLength());
                        continue block16;
                    }
                    case 80: {
                        Padding pv = (Padding)f2;
                        this.paddingCodec.writeData(pv.getLength());
                        continue block16;
                    }
                    case 68: {
                        Deletion dv = (Deletion)f2;
                        this.dlc.writeData(dv.getLength());
                        continue block16;
                    }
                    case 78: {
                        RefSkip rsv = (RefSkip)f2;
                        this.refSkipCodec.writeData(rsv.getLength());
                        continue block16;
                    }
                    case 105: {
                        InsertBase ib = (InsertBase)f2;
                        this.bc.writeData(ib.getBase());
                        continue block16;
                    }
                    case 81: {
                        BaseQualityScore bqs = (BaseQualityScore)f2;
                        this.qc.writeData(bqs.getQualityScore());
                        continue block16;
                    }
                }
                throw new RuntimeException("Unknown read feature operator: " + (char)f2.getOperator());
            }
            this.mqc.writeData(r2.mappingQuality);
            if (r2.isForcePreserveQualityScores()) {
                this.qcArray.writeData(r2.qualityScores);
            }
        } else {
            for (byte b2 : r2.readBases) {
                this.bc.writeData(b2);
            }
            if (r2.isForcePreserveQualityScores()) {
                this.qcArray.writeData(r2.qualityScores);
            }
        }
    }
}

