/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombIntegerCodec
extends AbstractBitCodec<Integer> {
    private int m;
    private boolean quotientBit = true;
    private int offset = 0;

    public GolombIntegerCodec(int m2) {
        this(m2, true, 0);
    }

    public GolombIntegerCodec(int m2, boolean quotientBit, Integer offset) {
        if (m2 < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m2;
        this.quotientBit = quotientBit;
        this.offset = offset;
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int quotient = 0;
        while (bis.readBit() == this.quotientBit) {
            ++quotient;
        }
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int reminder = bis.readBits(ceiling - 1);
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= bis.readBits(1);
            reminder = (int)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * this.m + reminder - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        int newValue = value + this.offset;
        int quotient = newValue / this.m;
        int reminder = newValue % this.m;
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int len = quotient + 1;
        bos.write(this.quotientBit, (long)quotient);
        bos.write(!this.quotientBit);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            bos.write(reminder, ceiling - 1);
            len += ceiling - 1;
        } else {
            bos.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), ceiling);
            len += ceiling;
        }
        return len;
    }

    @Override
    public final long numberOfBits(Integer value) {
        int newValue = value + this.offset;
        int quotient = newValue / this.m;
        int reminder = newValue % this.m;
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int l2 = quotient + 1;
        l2 = (double)reminder < Math.pow(2.0, ceiling) - (double)this.m ? (l2 += ceiling - 1) : (l2 += ceiling);
        return l2;
    }

    public long getM() {
        return this.m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setM(int m2) {
        this.m = m2;
    }

    public void setQuotientBit(boolean quotientBit) {
        this.quotientBit = quotientBit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

