/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.mask.RefMaskUtils;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Sam2CramRecordFactory {
    public static final String UNKNOWN_READ_GROUP_ID = "UNKNOWN";
    public static final String UNKNOWN_READ_GROUP_SAMPLE = "UNKNOWN";
    public static final byte QS_asciiOffset = 33;
    public static final byte unsetQualityScore = 32;
    public static final byte ignorePositionsWithQualityScore = -1;
    private byte[] refBases;
    private byte[] refSNPs;
    private RefMaskUtils.RefMask refPile;
    private static Log log = Log.getInstance(Sam2CramRecordFactory.class);
    private Map<String, Integer> readGroupMap = new HashMap<String, Integer>();
    private long landedRefMaskScores = 0L;
    private long landedPiledScores = 0L;
    private long landedTotalScores = 0L;
    public boolean captureAllTags = false;
    public boolean preserveReadNames = false;
    public Set<String> captureTags = new TreeSet<String>();
    public Set<String> ignoreTags = new TreeSet<String>();
    public boolean losslessQS;
    private List<ReadTag> readTagList;
    private long baseCount;
    private long featureCount;

    public Sam2CramRecordFactory(int samSequenceIndex, byte[] refBases, SAMFileHeader samFileHeader) {
        this.ignoreTags.add(SAMTag.NM.name());
        this.ignoreTags.add(SAMTag.MD.name());
        this.ignoreTags.add(SAMTag.RG.name());
        this.losslessQS = false;
        this.readTagList = new ArrayList<ReadTag>();
        this.baseCount = 0L;
        this.featureCount = 0L;
        this.refBases = refBases;
        List<SAMReadGroupRecord> readGroups = samFileHeader.getReadGroups();
        for (int i2 = 0; i2 < readGroups.size(); ++i2) {
            SAMReadGroupRecord readGroupRecord = readGroups.get(i2);
            this.readGroupMap.put(readGroupRecord.getId(), i2);
        }
    }

    public CramCompressionRecord createCramRecord(SAMRecord record) {
        List<SAMRecord.SAMTagAndValue> attributes;
        CramCompressionRecord cramRecord = new CramCompressionRecord();
        if (record.getReadPairedFlag()) {
            cramRecord.mateAlignmentStart = record.getMateAlignmentStart();
            cramRecord.setMateUmapped(record.getMateUnmappedFlag());
            cramRecord.setMateNegativeStrand(record.getMateNegativeStrandFlag());
            cramRecord.mateSequenceID = record.getMateReferenceIndex();
        } else {
            cramRecord.mateSequenceID = -1;
        }
        cramRecord.sequenceId = record.getReferenceIndex();
        cramRecord.readName = record.getReadName();
        cramRecord.alignmentStart = record.getAlignmentStart();
        cramRecord.setMultiFragment(record.getReadPairedFlag());
        cramRecord.setProperPair(record.getReadPairedFlag() && record.getProperPairFlag());
        cramRecord.setSegmentUnmapped(record.getReadUnmappedFlag());
        cramRecord.setNegativeStrand(record.getReadNegativeStrandFlag());
        cramRecord.setFirstSegment(record.getReadPairedFlag() && record.getFirstOfPairFlag());
        cramRecord.setLastSegment(record.getReadPairedFlag() && record.getSecondOfPairFlag());
        cramRecord.setSecondaryAlignment(record.getNotPrimaryAlignmentFlag());
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.readLength = record.getReadLength();
        cramRecord.mappingQuality = record.getMappingQuality();
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.templateSize = record.getInferredInsertSize();
        SAMReadGroupRecord readGroup = record.getReadGroup();
        cramRecord.readGroupID = readGroup != null ? this.readGroupMap.get(readGroup.getId()) : -1;
        if (!record.getReadPairedFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getFirstOfPairFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getSecondOfPairFlag()) {
            cramRecord.setLastSegment(true);
        } else {
            cramRecord.setLastSegment(true);
        }
        if (!record.getReadUnmappedFlag() && record.getAlignmentStart() != 0) {
            List<ReadFeature> features = this.checkedCreateVariations(cramRecord, record);
            cramRecord.readFeatures = features;
        } else {
            cramRecord.readFeatures = Collections.emptyList();
        }
        cramRecord.readBases = record.getReadBases();
        cramRecord.qualityScores = record.getBaseQualities();
        this.landedTotalScores += (long)cramRecord.readLength;
        this.readTagList.clear();
        if (this.captureAllTags) {
            attributes = record.getAttributes();
            for (SAMRecord.SAMTagAndValue tv : attributes) {
                if (this.ignoreTags.contains(tv.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tv.tag, tv.value));
            }
        } else if (!this.captureTags.isEmpty()) {
            attributes = record.getAttributes();
            cramRecord.tags = new ReadTag[attributes.size()];
            for (SAMRecord.SAMTagAndValue tv : attributes) {
                if (!this.captureTags.contains(tv.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tv.tag, tv.value));
            }
        }
        cramRecord.tags = this.readTagList.toArray(new ReadTag[this.readTagList.size()]);
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        if (this.preserveReadNames) {
            cramRecord.readName = record.getReadName();
        }
        return cramRecord;
    }

    private List<ReadFeature> checkedCreateVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        try {
            return this.createVariations(cramRecord, samRecord);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            log.error("Reference bases array length=" + this.refBases.length);
            log.error("Offensive CRAM record: " + cramRecord.toString());
            log.error("Offensive SAM record: " + samRecord.getSAMString());
            throw e2;
        }
    }

    private List<ReadFeature> createVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        LinkedList<ReadFeature> features = new LinkedList<ReadFeature>();
        int zeroBasedPositionInRead = 0;
        int alignmentStartOffset = 0;
        int cigarElementLength = 0;
        List<CigarElement> cigarElements = samRecord.getCigar().getCigarElements();
        byte[] bases = samRecord.getReadBases();
        byte[] qualityScore = samRecord.getBaseQualities();
        for (CigarElement cigarElement : cigarElements) {
            cigarElementLength = cigarElement.getLength();
            CigarOperator operator = cigarElement.getOperator();
            switch (operator) {
                case D: {
                    features.add(new Deletion(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case N: {
                    features.add(new RefSkip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case P: {
                    features.add(new Padding(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case H: {
                    features.add(new HardClip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case S: {
                    this.addSoftClip(features, zeroBasedPositionInRead, cigarElementLength, bases, qualityScore);
                    break;
                }
                case I: {
                    this.addInsertion(features, zeroBasedPositionInRead, cigarElementLength, bases, qualityScore);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    this.addSubstitutionsAndMaskedBases(cramRecord, features, zeroBasedPositionInRead, alignmentStartOffset, cigarElementLength, bases, qualityScore);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarElement.getOperator().consumesReadBases()) {
                zeroBasedPositionInRead += cigarElementLength;
            }
            if (!cigarElement.getOperator().consumesReferenceBases()) continue;
            alignmentStartOffset += cigarElementLength;
        }
        this.baseCount += (long)bases.length;
        this.featureCount += (long)features.size();
        return features;
    }

    private void addSoftClip(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases, byte[] scores) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        SoftClip v2 = new SoftClip(zeroBasedPositionInRead + 1, insertedBases);
        features.add(v2);
    }

    private void addInsertion(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases, byte[] scores) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        for (int i2 = 0; i2 < insertedBases.length; ++i2) {
            InsertBase ib = new InsertBase();
            ib.setPosition(zeroBasedPositionInRead + 1 + i2);
            ib.setBase(insertedBases[i2]);
            features.add(ib);
        }
    }

    private void addSubstitutionsAndMaskedBases(CramCompressionRecord cramRecord, List<ReadFeature> features, int fromPosInRead, int alignmentStartOffset, int nofReadBases, byte[] bases, byte[] qualityScore) {
        boolean noQS = qualityScore.length == 0;
        int i2 = 0;
        boolean qualityAdded = false;
        for (i2 = 0; i2 < nofReadBases; ++i2) {
            byte snpOrNot;
            int oneBasedPositionInRead = i2 + fromPosInRead + 1;
            int refCoord = cramRecord.alignmentStart + i2 + alignmentStartOffset - 1;
            qualityAdded = false;
            byte refBase = refCoord >= this.refBases.length ? (byte)78 : this.refBases[refCoord];
            if (bases[i2 + fromPosInRead] != (refBase = Utils.normalizeBase(refBase))) {
                Substitution sv = new Substitution();
                sv.setPosition(oneBasedPositionInRead);
                sv.setBase(bases[i2 + fromPosInRead]);
                sv.setRefernceBase(refBase);
                sv.setBaseChange(null);
                features.add(sv);
                if (this.losslessQS || noQS) continue;
            }
            if (noQS) continue;
            if (!qualityAdded && this.refSNPs != null && (snpOrNot = this.refSNPs[refCoord]) != 0) {
                byte score = (byte)(33 + qualityScore[i2 + fromPosInRead]);
                features.add(new BaseQualityScore(oneBasedPositionInRead, score));
                qualityAdded = true;
                ++this.landedRefMaskScores;
            }
            if (!qualityAdded && this.refPile != null && this.refPile.shouldStore(refCoord, refBase)) {
                byte score = (byte)(33 + qualityScore[i2 + fromPosInRead]);
                features.add(new BaseQualityScore(oneBasedPositionInRead, score));
                qualityAdded = true;
                ++this.landedPiledScores;
            }
            if (!qualityAdded) continue;
            ++this.landedTotalScores;
        }
    }

    public long getLandedRefMaskScores() {
        return this.landedRefMaskScores;
    }

    public long getLandedPiledScores() {
        return this.landedPiledScores;
    }

    public long getLandedTotalScores() {
        return this.landedTotalScores;
    }

    public byte[] getRefBases() {
        return this.refBases;
    }

    public void setRefBases(byte[] refBases) {
        this.refBases = refBases;
    }

    public byte[] getRefSNPs() {
        return this.refSNPs;
    }

    public void setRefSNPs(byte[] refSNPs) {
        this.refSNPs = refSNPs;
    }

    public RefMaskUtils.RefMask getRefPile() {
        return this.refPile;
    }

    public Map<String, Integer> getReadGroupMap() {
        return this.readGroupMap;
    }

    public void setRefPile(RefMaskUtils.RefMask refPile) {
        this.refPile = refPile;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }
}

