/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CramNormalizer {
    private SAMFileHeader header;
    private int readCounter = 0;
    private String readNamePrefix = "";
    private byte defaultQualityScore = (byte)30;
    private static Log log = Log.getInstance(CramNormalizer.class);
    private ReferenceSource referenceSource;

    public CramNormalizer(SAMFileHeader header) {
        this.header = header;
    }

    public CramNormalizer(SAMFileHeader header, ReferenceSource referenceSource) {
        this.header = header;
        this.referenceSource = referenceSource;
    }

    public void normalize(ArrayList<CramCompressionRecord> records, boolean resetPairing, byte[] ref, int alignmentStart, SubstitutionMatrix substitutionMatrix, boolean AP_delta) {
        int startCounter = this.readCounter;
        for (CramCompressionRecord r2 : records) {
            r2.index = ++this.readCounter;
            if (r2.sequenceId == -1) {
                r2.sequenceName = "*";
                r2.alignmentStart = 0;
                continue;
            }
            r2.sequenceName = this.header.getSequence(r2.sequenceId).getSequenceName();
        }
        for (CramCompressionRecord r2 : records) {
            int tlen;
            CramCompressionRecord downMate;
            if (!r2.isMultiFragment() || r2.isDetached()) {
                r2.recordsToNextFragment = -1;
                r2.next = null;
                r2.previous = null;
                continue;
            }
            if (!r2.isHasMateDownStream()) continue;
            r2.next = downMate = records.get(r2.index + r2.recordsToNextFragment - startCounter);
            downMate.previous = r2;
            r2.mateAlignmentStart = downMate.alignmentStart;
            r2.setMateUmapped(downMate.isSegmentUnmapped());
            r2.setMateNegativeStrand(downMate.isNegativeStrand());
            r2.mateSequenceID = downMate.sequenceId;
            if (r2.mateSequenceID == -1) {
                r2.mateAlignmentStart = 0;
            }
            downMate.mateAlignmentStart = r2.alignmentStart;
            downMate.setMateUmapped(r2.isSegmentUnmapped());
            downMate.setMateNegativeStrand(r2.isNegativeStrand());
            downMate.mateSequenceID = r2.sequenceId;
            if (downMate.mateSequenceID == -1) {
                downMate.mateAlignmentStart = 0;
            }
            if (r2.isFirstSegment()) {
                r2.templateSize = tlen = CramNormalizer.computeInsertSize(r2, downMate);
                downMate.templateSize = -tlen;
                continue;
            }
            downMate.templateSize = tlen = CramNormalizer.computeInsertSize(downMate, r2);
            r2.templateSize = -tlen;
        }
        for (CramCompressionRecord r2 : records) {
            String name;
            if (r2.readName != null) continue;
            r2.readName = name = this.readNamePrefix + r2.index;
            if (r2.next != null) {
                r2.next.readName = name;
            }
            if (r2.previous == null) continue;
            r2.previous.readName = name;
        }
        for (CramCompressionRecord r2 : records) {
            if (r2.isSegmentUnmapped()) continue;
            byte[] refBases = ref;
            if (this.referenceSource != null) {
                refBases = this.referenceSource.getReferenceBases(this.header.getSequence(r2.sequenceId), true);
            }
            byte[] bases = CramNormalizer.restoreReadBases(r2, refBases, substitutionMatrix);
            r2.readBases = bases;
        }
        CramNormalizer.restoreQualityScores(this.defaultQualityScore, records);
    }

    public static void restoreQualityScores(byte defaultQualityScore, List<CramCompressionRecord> records) {
        for (CramCompressionRecord record : records) {
            CramNormalizer.restoreQualityScores(defaultQualityScore, record);
        }
    }

    public static byte[] restoreQualityScores(byte defaultQualityScore, CramCompressionRecord record) {
        if (!record.isForcePreserveQualityScores()) {
            byte[] scores = new byte[record.readLength];
            Arrays.fill(scores, defaultQualityScore);
            if (record.readFeatures != null) {
                for (ReadFeature f2 : record.readFeatures) {
                    switch (f2.getOperator()) {
                        case 81: {
                            int pos = f2.getPosition();
                            byte q2 = ((BaseQualityScore)f2).getQualityScore();
                            try {
                                scores[pos - 1] = q2;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException e2) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(record.toString());
                                throw e2;
                            }
                        }
                        case 66: {
                            int pos = f2.getPosition();
                            byte q2 = ((ReadBase)f2).getQualityScore();
                            try {
                                scores[pos - 1] = q2;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException e3) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(record.toString());
                                throw e3;
                            }
                        }
                    }
                }
            }
            record.qualityScores = scores;
        } else {
            byte[] scores = record.qualityScores;
            for (int i2 = 0; i2 < scores.length; ++i2) {
                if (scores[i2] != -1) continue;
                scores[i2] = defaultQualityScore;
            }
        }
        return record.qualityScores;
    }

    private static final long calcRefLength(CramCompressionRecord record) {
        if (record.readFeatures == null || record.readFeatures.isEmpty()) {
            return record.readLength;
        }
        long len = record.readLength;
        for (ReadFeature rf : record.readFeatures) {
            switch (rf.getOperator()) {
                case 68: {
                    len += (long)((Deletion)rf).getLength();
                    break;
                }
                case 73: {
                    len -= (long)((Insertion)rf).getSequence().length;
                    break;
                }
            }
        }
        return len;
    }

    private static final byte[] restoreReadBases(CramCompressionRecord record, byte[] ref, SubstitutionMatrix substitutionMatrix) {
        int readLength = record.readLength;
        byte[] bases = new byte[readLength];
        int posInRead = 1;
        int alignmentStart = record.alignmentStart - 1;
        int posInSeq = 0;
        if (record.readFeatures == null || record.readFeatures.isEmpty()) {
            if (ref.length < alignmentStart + bases.length) {
                Arrays.fill(bases, (byte)78);
                System.arraycopy(ref, alignmentStart, bases, 0, Math.min(bases.length, ref.length - alignmentStart));
            } else {
                System.arraycopy(ref, alignmentStart, bases, 0, bases.length);
            }
            return bases;
        }
        List<ReadFeature> variations = record.readFeatures;
        block10: for (ReadFeature v2 : variations) {
            while (posInRead < v2.getPosition()) {
                bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
                ++posInRead;
            }
            switch (v2.getOperator()) {
                case 88: {
                    Substitution sv = (Substitution)v2;
                    byte refBase = Utils.normalizeBase(ref[alignmentStart + posInSeq]);
                    byte base = substitutionMatrix.base(refBase, sv.getCode());
                    sv.setBase(base);
                    sv.setRefernceBase(refBase);
                    bases[posInRead++ - 1] = base;
                    ++posInSeq;
                    break;
                }
                case 73: {
                    Insertion iv = (Insertion)v2;
                    for (int i2 = 0; i2 < iv.getSequence().length; ++i2) {
                        bases[posInRead++ - 1] = iv.getSequence()[i2];
                    }
                    continue block10;
                }
                case 83: {
                    SoftClip sc = (SoftClip)v2;
                    for (int i3 = 0; i3 < sc.getSequence().length; ++i3) {
                        bases[posInRead++ - 1] = sc.getSequence()[i3];
                    }
                    continue block10;
                }
                case 68: {
                    Deletion dv = (Deletion)v2;
                    posInSeq += dv.getLength();
                    break;
                }
                case 105: {
                    InsertBase ib = (InsertBase)v2;
                    bases[posInRead++ - 1] = ib.getBase();
                }
            }
        }
        while (posInRead <= readLength) {
            bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
            ++posInRead;
        }
        for (ReadFeature v2 : variations) {
            switch (v2.getOperator()) {
                case 66: {
                    ReadBase rb = (ReadBase)v2;
                    bases[v2.getPosition() - 1] = rb.getBase();
                    break;
                }
            }
        }
        for (int i4 = 0; i4 < bases.length; ++i4) {
            bases[i4] = Utils.normalizeBase(bases[i4]);
        }
        return bases;
    }

    private static int computeInsertSize(CramCompressionRecord firstEnd, CramCompressionRecord secondEnd) {
        if (firstEnd.isSegmentUnmapped() || secondEnd.isSegmentUnmapped()) {
            return 0;
        }
        if (firstEnd.sequenceId != secondEnd.sequenceId) {
            return 0;
        }
        int firstEnd5PrimePosition = firstEnd.isNegativeStrand() ? firstEnd.getAlignmentEnd() : firstEnd.alignmentStart;
        int secondEnd5PrimePosition = secondEnd.isNegativeStrand() ? secondEnd.getAlignmentEnd() : secondEnd.alignmentStart;
        int adjustment = secondEnd5PrimePosition >= firstEnd5PrimePosition ? 1 : -1;
        return secondEnd5PrimePosition - firstEnd5PrimePosition + adjustment;
    }
}

