/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.GraphDelegator;

public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
WeightedGraph<V, E> {
    private static final long serialVersionUID = -716810639338971372L;
    protected final Map<E, Double> weightMap;
    private final boolean isWeightedGraph;

    public AsWeightedGraph(Graph<V, E> graph, Map<E, Double> map) {
        super(graph);
        assert (map != null);
        this.weightMap = map;
        this.isWeightedGraph = graph instanceof WeightedGraph;
    }

    @Override
    public void setEdgeWeight(E e2, double d2) {
        if (this.isWeightedGraph) {
            super.setEdgeWeight(e2, d2);
        }
        this.weightMap.put(e2, d2);
    }

    @Override
    public double getEdgeWeight(E e2) {
        double d2 = this.weightMap.containsKey(e2) ? this.weightMap.get(e2).doubleValue() : super.getEdgeWeight(e2);
        return d2;
    }
}

