/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.contexts.ReferenceContext;
import org.broadinstitute.gatk.engine.datasources.providers.ShardDataProvider;
import org.broadinstitute.gatk.engine.traversals.TraversalEngine;
import org.broadinstitute.gatk.engine.walkers.ReadWalker;
import org.broadinstitute.gatk.engine.walkers.Walker;
import org.broadinstitute.gatk.utils.sam.ArtificialPatternedSAMIterator;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ArtificialReadsTraversal<M, T>
extends TraversalEngine<M, T, Walker<M, T>, ShardDataProvider> {
    public int startingChr = 1;
    public int endingChr = 5;
    public int readsPerChr = 100;
    public int unMappedReads = 1000;
    private int DEFAULT_READ_LENGTH = 50;
    private ArtificialPatternedSAMIterator iter;
    protected static Logger logger = Logger.getLogger(ArtificialReadsTraversal.class);
    private ArtificialPatternedSAMIterator.PATTERN readOrder = ArtificialPatternedSAMIterator.PATTERN.IN_ORDER_READS;

    public void setReadOrder(ArtificialPatternedSAMIterator.PATTERN readOrdering) {
        this.readOrder = readOrdering;
    }

    public String getTraversalUnits() {
        return "reads";
    }

    public T traverse(Walker<M, T> walker, ShardDataProvider dataProvider, T sum) {
        if (!(walker instanceof ReadWalker)) {
            throw new IllegalArgumentException("Walker isn't a read walker!");
        }
        ReadWalker readWalker = (ReadWalker)walker;
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(this.endingChr - this.startingChr + 1, this.startingChr, this.readsPerChr + this.DEFAULT_READ_LENGTH);
        this.iter = new ArtificialPatternedSAMIterator(this.startingChr, this.endingChr, this.readsPerChr, this.unMappedReads, header, this.readOrder);
        Iterator<SAMRecord> i$ = this.iter.iterator();
        while (i$.hasNext()) {
            ReferenceContext refSeq = null;
            SAMRecord read = i$.next();
            boolean keepMeP = readWalker.filter(refSeq, (GATKSAMRecord)read);
            if (!keepMeP) continue;
            Object x2 = readWalker.map(refSeq, (GATKSAMRecord)read, null);
            sum = readWalker.reduce(x2, sum);
        }
        return sum;
    }
}

