/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.TruthStatus;

public class MongoVCFVariant
extends VCFVariant {
    private static Logger log = Logger.getLogger(MongoVCFVariant.class);
    private final MongoVariantContext mongoVariantContext;

    @Override
    public String getAttributeAsString(String key) {
        if (key.equalsIgnoreCase("date")) {
            try {
                long date = Long.parseLong((String)super.getAttributes().get(key));
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy. HH:mm");
                return formatter.format(new Date(date));
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), e2);
            }
        }
        return super.getAttributeAsString(key);
    }

    public MongoVCFVariant(MongoVariantContext mongoVariantContext, String chr) {
        super(mongoVariantContext.getVariantContext(), chr);
        this.mongoVariantContext = mongoVariantContext;
    }

    public TruthStatus getTruthStatus() {
        return this.mongoVariantContext.getType();
    }

    public boolean isReviewed() {
        return this.mongoVariantContext.isReviewed();
    }
}

