/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Element;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    static final double SQRT2 = Math.sqrt(2.0);

    protected UnitProcessor() {
    }

    public static float svgToObjectBoundingBox(String s2, String attr, short d2, Context ctx) throws ParseException {
        LengthParser lengthParser = new LengthParser();
        UnitResolver ur = new UnitResolver();
        lengthParser.setLengthHandler(ur);
        lengthParser.parse(s2);
        return UnitProcessor.svgToObjectBoundingBox(ur.value, ur.unit, d2, ctx);
    }

    public static float svgToObjectBoundingBox(float value, short type, short d2, Context ctx) {
        switch (type) {
            case 1: {
                return value;
            }
            case 2: {
                return value / 100.0f;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return UnitProcessor.svgToUserSpace(value, type, d2, ctx);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float svgToUserSpace(String s2, String attr, short d2, Context ctx) throws ParseException {
        LengthParser lengthParser = new LengthParser();
        UnitResolver ur = new UnitResolver();
        lengthParser.setLengthHandler(ur);
        lengthParser.parse(s2);
        return UnitProcessor.svgToUserSpace(ur.value, ur.unit, d2, ctx);
    }

    public static float svgToUserSpace(float v2, short type, short d2, Context ctx) {
        switch (type) {
            case 1: 
            case 5: {
                return v2;
            }
            case 7: {
                return v2 / ctx.getPixelUnitToMillimeter();
            }
            case 6: {
                return v2 * 10.0f / ctx.getPixelUnitToMillimeter();
            }
            case 8: {
                return v2 * 25.4f / ctx.getPixelUnitToMillimeter();
            }
            case 9: {
                return v2 * 25.4f / (72.0f * ctx.getPixelUnitToMillimeter());
            }
            case 10: {
                return v2 * 25.4f / (6.0f * ctx.getPixelUnitToMillimeter());
            }
            case 3: {
                return UnitProcessor.emsToPixels(v2, d2, ctx);
            }
            case 4: {
                return UnitProcessor.exsToPixels(v2, d2, ctx);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(v2, d2, ctx);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float userSpaceToSVG(float v2, short type, short d2, Context ctx) {
        switch (type) {
            case 1: 
            case 5: {
                return v2;
            }
            case 7: {
                return v2 * ctx.getPixelUnitToMillimeter();
            }
            case 6: {
                return v2 * ctx.getPixelUnitToMillimeter() / 10.0f;
            }
            case 8: {
                return v2 * ctx.getPixelUnitToMillimeter() / 25.4f;
            }
            case 9: {
                return v2 * (72.0f * ctx.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 10: {
                return v2 * (6.0f * ctx.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 3: {
                return UnitProcessor.pixelsToEms(v2, d2, ctx);
            }
            case 4: {
                return UnitProcessor.pixelsToExs(v2, d2, ctx);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(v2, d2, ctx);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    protected static float percentagesToPixels(float v2, short d2, Context ctx) {
        if (d2 == 2) {
            float w2 = ctx.getViewportWidth();
            return w2 * v2 / 100.0f;
        }
        if (d2 == 1) {
            float h2 = ctx.getViewportHeight();
            return h2 * v2 / 100.0f;
        }
        double w3 = ctx.getViewportWidth();
        double h3 = ctx.getViewportHeight();
        double vpp = Math.sqrt(w3 * w3 + h3 * h3) / SQRT2;
        return (float)(vpp * (double)v2 / 100.0);
    }

    protected static float pixelsToPercentages(float v2, short d2, Context ctx) {
        if (d2 == 2) {
            float w2 = ctx.getViewportWidth();
            return v2 * 100.0f / w2;
        }
        if (d2 == 1) {
            float h2 = ctx.getViewportHeight();
            return v2 * 100.0f / h2;
        }
        double w3 = ctx.getViewportWidth();
        double h3 = ctx.getViewportHeight();
        double vpp = Math.sqrt(w3 * w3 + h3 * h3) / SQRT2;
        return (float)((double)v2 * 100.0 / vpp);
    }

    protected static float pixelsToEms(float v2, short d2, Context ctx) {
        return v2 / ctx.getFontSize();
    }

    protected static float emsToPixels(float v2, short d2, Context ctx) {
        return v2 * ctx.getFontSize();
    }

    protected static float pixelsToExs(float v2, short d2, Context ctx) {
        float xh = ctx.getXHeight();
        return v2 / xh / ctx.getFontSize();
    }

    protected static float exsToPixels(float v2, short d2, Context ctx) {
        float xh = ctx.getXHeight();
        return v2 * xh * ctx.getFontSize();
    }

    public static interface Context {
        public Element getElement();

        public float getPixelUnitToMillimeter();

        public float getPixelToMM();

        public float getFontSize();

        public float getXHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    implements LengthHandler {
        public float value;
        public short unit = 1;

        public void startLength() throws ParseException {
        }

        public void lengthValue(float v2) throws ParseException {
            this.value = v2;
        }

        public void em() throws ParseException {
            this.unit = (short)3;
        }

        public void ex() throws ParseException {
            this.unit = (short)4;
        }

        public void in() throws ParseException {
            this.unit = (short)8;
        }

        public void cm() throws ParseException {
            this.unit = (short)6;
        }

        public void mm() throws ParseException {
            this.unit = (short)7;
        }

        public void pc() throws ParseException {
            this.unit = (short)10;
        }

        public void pt() throws ParseException {
            this.unit = (short)9;
        }

        public void px() throws ParseException {
            this.unit = (short)5;
        }

        public void percentage() throws ParseException {
            this.unit = (short)2;
        }

        public void endLength() throws ParseException {
        }
    }
}

