/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class TextFormattingUtils {
    private static Logger logger = Logger.getLogger(TextFormattingUtils.class);
    public static final int DEFAULT_LINE_WIDTH = 120;

    public static List<String> wordWrap(String text, int width) {
        Pattern wrapper = Pattern.compile(String.format(".{0,%d}(?:\\S(?:[\\s|]|$)|$)", width - 1));
        Matcher matcher = wrapper.matcher(text);
        ArrayList<String> wrapped = new ArrayList<String>();
        while (matcher.find()) {
            String line = matcher.group().trim();
            if (line.length() <= 0) continue;
            wrapped.add(matcher.group());
        }
        return wrapped;
    }

    public static ResourceBundle loadResourceBundle(String bundleName) {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(bundleName);
        }
        catch (MissingResourceException ex) {
            try {
                bundle = new PropertyResourceBundle(new StringReader(""));
            }
            catch (IOException ioe) {
                throw new ReviewedGATKException("No resource bundle found, and unable to create an empty placeholder.", ioe);
            }
        }
        return bundle;
    }

    public static List<Integer> getWordStarts(String line) {
        if (line == null) {
            throw new ReviewedGATKException("line is null");
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int stop = line.length();
        for (int i2 = 1; i2 < stop; ++i2) {
            if (!Character.isWhitespace(line.charAt(i2 - 1)) || Character.isWhitespace(line.charAt(i2))) continue;
            starts.add(i2);
        }
        return starts;
    }

    public static String[] splitFixedWidth(String line, List<Integer> columnStarts) {
        if (line == null) {
            throw new ReviewedGATKException("line is null");
        }
        if (columnStarts == null) {
            throw new ReviewedGATKException("columnStarts is null");
        }
        int startCount = columnStarts.size();
        String[] row = new String[startCount + 1];
        if (startCount == 0) {
            row[0] = line.trim();
        } else {
            row[0] = line.substring(0, columnStarts.get(0)).trim();
            for (int i2 = 1; i2 < startCount; ++i2) {
                row[i2] = line.substring(columnStarts.get(i2 - 1), columnStarts.get(i2)).trim();
            }
            row[startCount] = line.substring(columnStarts.get(startCount - 1)).trim();
        }
        return row;
    }

    public static String[] splitWhiteSpace(String line) {
        if (line == null) {
            throw new ReviewedGATKException("line is null");
        }
        return line.trim().split("\\s+");
    }

    public static class CaseInsensitiveComparator
    implements Comparator<String> {
        @Override
        public int compare(String lhs, String rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            return lhs.toLowerCase().compareTo(rhs.toLowerCase());
        }
    }
}

