/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class LRUCache<K, V> {
    private AtomicInteger maxEntries;
    private Map<K, V> map;

    public LRUCache(int max) {
        this.maxEntries = new AtomicInteger(max);
    }

    public void setMaxEntries(int max) {
        this.maxEntries.set(max);
    }

    private void createMap() {
        this.map = Collections.synchronizedMap(new LinkedHashMap<K, V>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.maxEntries.get();
            }
        });
    }

    private Map<K, V> getMap() {
        if (this.map == null) {
            this.createMap();
        }
        return this.map;
    }

    public V put(K k2, V v2) {
        return this.getMap().put(k2, v2);
    }

    public V get(Object key) {
        return this.getMap().get(key);
    }

    public boolean containsKey(Object o2) {
        return this.getMap().containsKey(o2);
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public void clear() {
        this.getMap().clear();
    }

    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    public Collection<V> values() {
        return this.getMap().values();
    }

    public void putAll(Map<K, V> map) {
        this.getMap().putAll(map);
    }

    public void putAll(LRUCache<K, V> intervals) {
        this.putAll(super.getMap());
    }
}

