/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongocollab;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.dev.api.NamedFeatureSearcher;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.plugin.mongocollab.DBFeature;
import org.broad.igv.plugin.mongocollab.MongoCollabPlugin;
import org.broad.igv.plugin.mongocollab.MongoFeatureTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.action.SearchCommand;

public class MongoFeatureSource
implements FeatureSource<DBFeature.IGVFeat>,
NamedFeatureSearcher {
    private int featureWindowSize = 1000000;
    private DBCollection collection;
    private boolean hasLocusIndex = false;
    private static Logger log = Logger.getLogger(MongoCollabPlugin.class);

    public MongoFeatureSource(DBCollection collection, boolean buildLocusIndex) {
        this.collection = collection;
        this.collection.setObjectClass(DBFeature.class);
        this.checkForLocusIndex(buildLocusIndex);
    }

    boolean hasLocusIndex() {
        return this.hasLocusIndex;
    }

    private void checkForLocusIndex(boolean buildIndex) {
        if (buildIndex) {
            this.ensureLocusIndex(this.collection);
        }
        List<DBObject> indexes = this.collection.getIndexInfo();
        DBObject neededFields = this.getLocusIndexKeys();
        for (DBObject index : indexes) {
            boolean isMatchingIndex = true;
            DBObject indexKey = (DBObject)index.get("key");
            for (String key : neededFields.keySet()) {
                boolean hasKey = indexKey.containsField(key);
                if (!hasKey) {
                    isMatchingIndex = false;
                    break;
                }
                Object value = indexKey.get(key);
                boolean equals = neededFields.get(key).equals(value);
                isMatchingIndex &= equals;
            }
            if (!isMatchingIndex) continue;
            this.hasLocusIndex = true;
            break;
        }
    }

    private DBObject createQueryObject(String chr, int start, int end) {
        BasicDBObject query = new BasicDBObject("Chr", chr);
        query.append("Start", new BasicDBObject("$lte", (Object)end));
        query.append("End", new BasicDBObject("$gte", (Object)start));
        return query;
    }

    private DBObject getLocusIndexKeys() {
        BasicDBObject indexKeys = new BasicDBObject("Chr", 1.0);
        indexKeys.append("Start", 1.0);
        indexKeys.append("End", 1.0);
        return indexKeys;
    }

    private void ensureLocusIndex(DBCollection collection) {
        collection.ensureIndex(this.getLocusIndexKeys());
    }

    @Override
    public Iterator<DBFeature.IGVFeat> getFeatures(String chr, int start, int end) throws IOException {
        return this.getFeatures(this.createQueryObject(chr, start, end), 0).iterator();
    }

    @Override
    public Collection<? extends NamedFeature> search(String name, int limit) {
        BasicDBObject dbObj = new BasicDBObject("UpperName", name.toUpperCase());
        try {
            return this.getFeatures(dbObj, limit);
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
            return null;
        }
    }

    private Collection<DBFeature.IGVFeat> getFeatures(DBObject queryObject, int limit) throws IOException {
        DBCursor cursor = this.collection.find(queryObject);
        cursor.limit(limit >= 0 ? limit : 0);
        if (this.hasLocusIndex) {
            cursor.sort(new BasicDBObject("Start", (Object)1));
        }
        boolean isSorted = true;
        int lastStart = -1;
        ArrayList<DBFeature.IGVFeat> features = new ArrayList<DBFeature.IGVFeat>();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            DBFeature feat = (DBFeature)obj;
            features.add(feat.createIGVFeature());
            isSorted &= feat.getStart() >= lastStart;
            lastStart = feat.getStart();
        }
        if (!isSorted) {
            FeatureUtils.sortFeatureList(features);
        }
        return features;
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
    }

    DBCollection getCollection() {
        return this.collection;
    }

    public static FeatureTrack loadFeatureTrack(MongoCollabPlugin.Locator locator, List<Track> newTracks) {
        DBCollection collection = MongoCollabPlugin.getCollection(locator);
        collection.setObjectClass(DBFeature.class);
        MongoFeatureSource source = new MongoFeatureSource(collection, locator.buildLocusIndex);
        MongoFeatureTrack track = new MongoFeatureTrack(collection.getFullName(), collection.getName(), source);
        SearchCommand.registerNamedFeatureSearcher(source);
        newTracks.add(track);
        track.setMargin(0);
        return track;
    }
}

