/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broad.igv.maf.AbstractMultipleAlignmentDialog;
import org.broad.igv.maf.MultipleAlignmentTrack;
import org.jdesktop.layout.GroupLayout;

public class Multiz44ConfigurationDialog
extends AbstractMultipleAlignmentDialog {
    static String[] primates = new String[]{"panTro2", "gorGor1", "ponAbe2", "rheMac2", "calJac1", "tarSyr1", "micMur1", "otoGar1"};
    static String[] mammals = new String[]{"tupBel1", "mm9", "rn4", "dipOrd1", "cavPor3", "speTri1", "oryCun1", "ochPri2", "vicPac1", "turTru1", "bosTau4", "equCab2", "felCat3", "canFam2", "myoLuc1", "pteVam1", "eriEur1", "sorAra1", "loxAfr2", "proCap1", "echTel1", "dasNov2", "choHof1"};
    static String[] vertebrates = new String[]{"monDom4", "ornAna1", "galGal3", "taeGut1", "anoCar1", "xenTro2", "tetNig1", "fr2", "gasAcu1", "oryLat28", "danRer5", "petMar1"};
    boolean cancelled = false;
    MultipleAlignmentTrack track;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JCheckBox mammalCheckbox;
    private JPanel mammalsPanel;
    private JButton okButton;
    private JCheckBox primateCheckbox;
    private JPanel primatePanel;
    private JCheckBox vertebrateCheckbox;
    private JPanel vertebratePanel;

    public Multiz44ConfigurationDialog(Frame parent, boolean modal, MultipleAlignmentTrack track) {
        super(parent, modal);
        this.track = track;
        this.initComponents();
        ((SpeciesSelectionPanel)this.primatePanel).checkForAllSelections();
        ((SpeciesSelectionPanel)this.mammalsPanel).checkForAllSelections();
        ((SpeciesSelectionPanel)this.vertebratePanel).checkForAllSelections();
    }

    @Override
    public List<String> getSelectedSpecies() {
        ArrayList<String> selectedSpecies = new ArrayList<String>(44);
        selectedSpecies.addAll(((SpeciesSelectionPanel)this.primatePanel).getSelectedSpecies());
        selectedSpecies.addAll(((SpeciesSelectionPanel)this.mammalsPanel).getSelectedSpecies());
        selectedSpecies.addAll(((SpeciesSelectionPanel)this.vertebratePanel).getSelectedSpecies());
        return selectedSpecies;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    private void initComponents() {
        this.primatePanel = new SpeciesSelectionPanel(Category.Primate);
        this.mammalsPanel = new SpeciesSelectionPanel(Category.Mammal);
        this.vertebratePanel = new SpeciesSelectionPanel(Category.Vertebrate);
        this.primateCheckbox = new JCheckBox();
        this.mammalCheckbox = new JCheckBox();
        this.vertebrateCheckbox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.primatePanel.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.primatePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.primatePanel.setMinimumSize(new Dimension(2, 60));
        this.primatePanel.setPreferredSize(new Dimension(727, 60));
        this.primatePanel.setLayout(new GridLayout(2, 5));
        this.mammalsPanel.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.mammalsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.mammalsPanel.setMinimumSize(new Dimension(2, 60));
        this.mammalsPanel.setPreferredSize(new Dimension(727, 60));
        this.mammalsPanel.setLayout(new GridLayout(6, 5));
        this.vertebratePanel.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.vertebratePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.vertebratePanel.setMinimumSize(new Dimension(2, 60));
        this.vertebratePanel.setPreferredSize(new Dimension(727, 60));
        this.vertebratePanel.setLayout(new GridLayout(3, 5));
        this.primateCheckbox.setText("Primates");
        this.primateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Multiz44ConfigurationDialog.this.primateCheckboxActionPerformed(evt);
            }
        });
        this.mammalCheckbox.setText("Mammals");
        this.mammalCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Multiz44ConfigurationDialog.this.mammalCheckboxActionPerformed(evt);
            }
        });
        this.vertebrateCheckbox.setText("Verterbrates");
        this.vertebrateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Multiz44ConfigurationDialog.this.vertebrateCheckboxActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel1.setText("Multiz Species Selection");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Multiz44ConfigurationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Multiz44ConfigurationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.vertebrateCheckbox).add(630, 630, 630)).add(layout.createSequentialGroup().add(this.jLabel1, -2, 293, -2).addContainerGap(454, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.mammalCheckbox).addContainerGap(661, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.primateCheckbox).addContainerGap(667, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(layout.createParallelGroup(2, false).add(1, this.vertebratePanel, 0, 0, Short.MAX_VALUE).add(1, this.mammalsPanel, 0, 0, Short.MAX_VALUE).add(1, this.primatePanel, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(451, 451, 451).add(this.okButton).add(18, 18, 18).add(this.cancelButton))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabel1, -2, 28, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.primateCheckbox).addPreferredGap(1).add(this.primatePanel, -2, -1, -2).add(46, 46, 46).add(this.mammalCheckbox).addPreferredGap(0).add(this.mammalsPanel, -2, 221, -2).add(28, 28, 28).add(this.vertebrateCheckbox).addPreferredGap(0).add(this.vertebratePanel, -2, 100, -2).add(34, 34, 34).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void primateCheckboxActionPerformed(ActionEvent evt) {
        ((SpeciesSelectionPanel)this.primatePanel).setSelectedAll(this.primateCheckbox.isSelected());
    }

    private void mammalCheckboxActionPerformed(ActionEvent evt) {
        ((SpeciesSelectionPanel)this.mammalsPanel).setSelectedAll(this.mammalCheckbox.isSelected());
    }

    private void vertebrateCheckboxActionPerformed(ActionEvent evt) {
        ((SpeciesSelectionPanel)this.vertebratePanel).setSelectedAll(this.vertebrateCheckbox.isSelected());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    class SpeciesSelectionPanel
    extends JPanel {
        int nColumns = 4;
        String[] speciesIds;
        JCheckBox[] checkboxes;
        Category category;

        public SpeciesSelectionPanel(Category category) {
            this.category = category;
            switch (category) {
                case Primate: {
                    this.speciesIds = primates;
                    break;
                }
                case Mammal: {
                    this.speciesIds = mammals;
                    break;
                }
                case Vertebrate: {
                    this.speciesIds = vertebrates;
                }
            }
            this.checkboxes = new JCheckBox[this.speciesIds.length];
            this.init();
        }

        private void init() {
            HashSet<String> currentSelections = new HashSet<String>(Multiz44ConfigurationDialog.this.track.getSelectedSpecies());
            int nRows = this.speciesIds.length / this.nColumns + 1;
            int height = nRows * 20;
            this.setSize(600, height);
            this.setMaximumSize(new Dimension(600, height));
            for (int i2 = 0; i2 < this.speciesIds.length; ++i2) {
                String sp = this.speciesIds[i2];
                String label = Multiz44ConfigurationDialog.this.track.getSpeciesName(sp);
                if (label == null) {
                    label = sp;
                }
                this.checkboxes[i2] = new JCheckBox(label);
                this.checkboxes[i2].setSelected(currentSelections == null || currentSelections.contains(sp));
                this.checkboxes[i2].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SpeciesSelectionPanel.this.checkboxAction(evt);
                    }
                });
                this.add(this.checkboxes[i2]);
            }
        }

        private void checkboxAction(ActionEvent evt) {
            this.checkForAllSelections();
        }

        public void checkForAllSelections() {
            JCheckBox masterCheckbox = this.getMasterCheckbox();
            if (this.isAllSelected()) {
                if (!masterCheckbox.isSelected()) {
                    masterCheckbox.setSelected(true);
                }
            } else if (masterCheckbox.isSelected()) {
                masterCheckbox.setSelected(false);
            }
        }

        private JCheckBox getMasterCheckbox() {
            switch (this.category) {
                case Primate: {
                    return Multiz44ConfigurationDialog.this.primateCheckbox;
                }
                case Mammal: {
                    return Multiz44ConfigurationDialog.this.mammalCheckbox;
                }
                case Vertebrate: {
                    return Multiz44ConfigurationDialog.this.vertebrateCheckbox;
                }
            }
            return null;
        }

        public void setSelectedAll(boolean selected) {
            for (JCheckBox cb : this.checkboxes) {
                cb.setSelected(selected);
            }
        }

        private boolean isAllSelected() {
            for (JCheckBox cb : this.checkboxes) {
                if (cb.isSelected()) continue;
                return false;
            }
            return true;
        }

        public List<String> getSelectedSpecies() {
            ArrayList<String> selections = new ArrayList<String>(this.speciesIds.length);
            for (int i2 = 0; i2 < this.speciesIds.length; ++i2) {
                if (!this.checkboxes[i2].isSelected()) continue;
                selections.add(this.speciesIds[i2]);
            }
            return selections;
        }
    }

    static enum Category {
        Primate,
        Mammal,
        Vertebrate;

    }
}

