/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class GenomeDescriptor {
    private String name;
    private boolean chrNamesAltered;
    private String id;
    protected String cytoBandFileName;
    protected String geneFileName;
    protected String chrAliasFileName;
    private String geneTrackName;
    private String url;
    private String sequenceLocation;
    private boolean hasCustomSequenceLocation;
    private boolean chromosomesAreOrdered = false;
    private boolean fasta = false;
    private boolean fastaDirectory = false;
    private String[] fastaFileNames;

    public GenomeDescriptor(String name, boolean chrNamesAltered, String id, String cytoBandFileName, String geneFileName, String chrAliasFileName, String geneTrackName, String sequenceLocation, boolean hasCustomSequenceLocation, boolean chromosomesAreOrdered, boolean fasta, boolean fastaDirectory, String fastaFileNameString) {
        String tryThis;
        this.chrNamesAltered = chrNamesAltered;
        this.name = name;
        this.id = id;
        this.cytoBandFileName = cytoBandFileName;
        this.geneFileName = geneFileName;
        this.chrAliasFileName = chrAliasFileName;
        this.geneTrackName = geneTrackName;
        this.sequenceLocation = sequenceLocation;
        this.hasCustomSequenceLocation = hasCustomSequenceLocation;
        this.chromosomesAreOrdered = chromosomesAreOrdered;
        this.fasta = fasta;
        this.fastaDirectory = fastaDirectory;
        if (fastaFileNameString != null) {
            this.fastaFileNames = fastaFileNameString.split(",");
        }
        if (sequenceLocation != null && sequenceLocation.startsWith("/") && !new File(sequenceLocation).exists() && new File(tryThis = sequenceLocation.replaceFirst("/", "")).exists()) {
            this.sequenceLocation = tryThis;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getGeneFileName() {
        return this.geneFileName;
    }

    public String getGeneTrackName() {
        return this.geneTrackName;
    }

    public String[] getFastaFileNames() {
        return this.fastaFileNames;
    }

    public abstract InputStream getCytoBandStream() throws IOException;

    public abstract InputStream getGeneStream() throws IOException;

    public abstract InputStream getChrAliasStream() throws IOException;

    public void setSequenceLocation(String sequenceLocation) {
        this.sequenceLocation = sequenceLocation;
    }

    public String getSequenceLocation() {
        return this.sequenceLocation;
    }

    public String toString() {
        return this.name;
    }

    private boolean isFileGZipFormat(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(".gz");
    }

    public boolean isChromosomesAreOrdered() {
        return this.chromosomesAreOrdered;
    }

    public boolean isChrNamesAltered() {
        return this.chrNamesAltered;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isFasta() {
        return this.fasta;
    }

    public boolean hasCytobands() {
        return this.cytoBandFileName != null && this.cytoBandFileName.length() > 0;
    }

    public abstract void close();

    public boolean hasCustomSequenceLocation() {
        return this.hasCustomSequenceLocation;
    }
}

