/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;

public class SCrypt {
    public static byte[] generate(byte[] P, byte[] S, int N, int r2, int p2, int dkLen) {
        return SCrypt.MFcrypt(P, S, N, r2, p2, dkLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] MFcrypt(byte[] P, byte[] S, int N, int r2, int p2, int dkLen) {
        byte[] byArray;
        int MFLenBytes = r2 * 128;
        byte[] bytes = SCrypt.SingleIterationPBKDF2(P, S, p2 * MFLenBytes);
        int[] B = null;
        try {
            int BLen = bytes.length >>> 2;
            B = new int[BLen];
            Pack.littleEndianToInt(bytes, 0, B);
            int MFLenWords = MFLenBytes >>> 2;
            for (int BOff = 0; BOff < BLen; BOff += MFLenWords) {
                SCrypt.SMix(B, BOff, N, r2);
            }
            Pack.intToLittleEndian(B, bytes, 0);
            byArray = SCrypt.SingleIterationPBKDF2(P, bytes, dkLen);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(bytes);
            SCrypt.Clear(B);
            throw throwable;
        }
        SCrypt.Clear(bytes);
        SCrypt.Clear(B);
        return byArray;
    }

    private static byte[] SingleIterationPBKDF2(byte[] P, byte[] S, int dkLen) {
        PKCS5S2ParametersGenerator pGen = new PKCS5S2ParametersGenerator(new SHA256Digest());
        pGen.init(P, S, 1);
        KeyParameter key = (KeyParameter)((PBEParametersGenerator)pGen).generateDerivedMacParameters(dkLen * 8);
        return key.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void SMix(int[] B, int BOff, int N, int r2) {
        int BCount = r2 * 32;
        int[] blockX1 = new int[16];
        int[] blockX2 = new int[16];
        int[] blockY = new int[BCount];
        int[] X = new int[BCount];
        int[][] V = new int[N][];
        try {
            System.arraycopy(B, BOff, X, 0, BCount);
            for (int i2 = 0; i2 < N; ++i2) {
                V[i2] = Arrays.clone(X);
                SCrypt.BlockMix(X, blockX1, blockX2, blockY, r2);
            }
            int mask = N - 1;
            for (int i3 = 0; i3 < N; ++i3) {
                int j2 = X[BCount - 16] & mask;
                SCrypt.Xor(X, V[j2], 0, X);
                SCrypt.BlockMix(X, blockX1, blockX2, blockY, r2);
            }
            System.arraycopy(X, 0, B, BOff, BCount);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(V);
            SCrypt.ClearAll(new int[][]{X, blockX1, blockX2, blockY});
            throw throwable;
        }
        SCrypt.ClearAll(V);
        SCrypt.ClearAll(new int[][]{X, blockX1, blockX2, blockY});
    }

    private static void BlockMix(int[] B, int[] X1, int[] X2, int[] Y, int r2) {
        System.arraycopy(B, B.length - 16, X1, 0, 16);
        int BOff = 0;
        int YOff = 0;
        int halfLen = B.length >>> 1;
        for (int i2 = 2 * r2; i2 > 0; --i2) {
            SCrypt.Xor(X1, B, BOff, X2);
            Salsa20Engine.salsaCore(8, X2, X1);
            System.arraycopy(X1, 0, Y, YOff, 16);
            YOff = halfLen + BOff - YOff;
            BOff += 16;
        }
        System.arraycopy(Y, 0, B, 0, Y.length);
    }

    private static void Xor(int[] a2, int[] b2, int bOff, int[] output) {
        for (int i2 = output.length - 1; i2 >= 0; --i2) {
            output[i2] = a2[i2] ^ b2[bOff + i2];
        }
    }

    private static void Clear(byte[] array) {
        if (array != null) {
            Arrays.fill(array, (byte)0);
        }
    }

    private static void Clear(int[] array) {
        if (array != null) {
            Arrays.fill(array, 0);
        }
    }

    private static void ClearAll(int[][] arrays) {
        for (int i2 = 0; i2 < arrays.length; ++i2) {
            SCrypt.Clear(arrays[i2]);
        }
    }
}

