/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.util.BigIntegers;

class DHParametersHelper {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DHParametersHelper() {
    }

    static BigInteger[] generateSafePrimes(int size, int certainty, SecureRandom random) {
        BigInteger q2;
        BigInteger p2;
        int qLength = size - 1;
        while (!(p2 = (q2 = new BigInteger(qLength, 2, random)).shiftLeft(1).add(ONE)).isProbablePrime(certainty) || certainty > 2 && !q2.isProbablePrime(certainty)) {
        }
        return new BigInteger[]{p2, q2};
    }

    static BigInteger selectGenerator(BigInteger p2, BigInteger q2, SecureRandom random) {
        BigInteger h2;
        BigInteger g2;
        BigInteger pMinusTwo = p2.subtract(TWO);
        while ((g2 = (h2 = BigIntegers.createRandomInRange(TWO, pMinusTwo, random)).modPow(TWO, p2)).equals(ONE)) {
        }
        return g2;
    }
}

