/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.MQVPublicParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public class ECMQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (MQVPrivateParameters)key;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        MQVPublicParameters pubParams = (MQVPublicParameters)pubKey;
        ECPrivateKeyParameters staticPrivateKey = this.privParams.getStaticPrivateKey();
        ECPoint agreement = this.calculateMqvAgreement(staticPrivateKey.getParameters(), staticPrivateKey, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), pubParams.getStaticPublicKey(), pubParams.getEphemeralPublicKey());
        return agreement.getX().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters parameters, ECPrivateKeyParameters d1U, ECPrivateKeyParameters d2U, ECPublicKeyParameters Q2U, ECPublicKeyParameters Q1V, ECPublicKeyParameters Q2V) {
        BigInteger n2 = parameters.getN();
        int e2 = (n2.bitLength() + 1) / 2;
        BigInteger powE = ECConstants.ONE.shiftLeft(e2);
        ECPoint q2 = Q2U == null ? parameters.getG().multiply(d2U.getD()) : Q2U.getQ();
        BigInteger x2 = q2.getX().toBigInteger();
        BigInteger xBar = x2.mod(powE);
        BigInteger Q2UBar = xBar.setBit(e2);
        BigInteger s2 = d1U.getD().multiply(Q2UBar).mod(n2).add(d2U.getD()).mod(n2);
        BigInteger xPrime = Q2V.getQ().getX().toBigInteger();
        BigInteger xPrimeBar = xPrime.mod(powE);
        BigInteger Q2VBar = xPrimeBar.setBit(e2);
        BigInteger hs = parameters.getH().multiply(s2).mod(n2);
        ECPoint p2 = ECAlgorithms.sumOfTwoMultiplies(Q1V.getQ(), Q2VBar.multiply(hs).mod(n2), Q2V.getQ(), hs);
        if (p2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return p2;
    }
}

