/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class SignerAttribute
extends ASN1Object {
    private Object[] values;

    public static SignerAttribute getInstance(Object o2) {
        if (o2 instanceof SignerAttribute) {
            return (SignerAttribute)o2;
        }
        if (o2 != null) {
            return new SignerAttribute(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private SignerAttribute(ASN1Sequence seq) {
        int index = 0;
        this.values = new Object[seq.size()];
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(e2.nextElement());
            if (taggedObject.getTagNo() == 0) {
                ASN1Sequence attrs = ASN1Sequence.getInstance(taggedObject, true);
                Attribute[] attributes = new Attribute[attrs.size()];
                for (int i2 = 0; i2 != attributes.length; ++i2) {
                    attributes[i2] = Attribute.getInstance(attrs.getObjectAt(i2));
                }
                this.values[index] = attributes;
            } else if (taggedObject.getTagNo() == 1) {
                this.values[index] = AttributeCertificate.getInstance(ASN1Sequence.getInstance(taggedObject, true));
            } else {
                throw new IllegalArgumentException("illegal tag: " + taggedObject.getTagNo());
            }
            ++index;
        }
    }

    public SignerAttribute(Attribute[] claimedAttributes) {
        this.values = new Object[1];
        this.values[0] = claimedAttributes;
    }

    public SignerAttribute(AttributeCertificate certifiedAttributes) {
        this.values = new Object[1];
        this.values[0] = certifiedAttributes;
    }

    public Object[] getValues() {
        return this.values;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.values.length; ++i2) {
            if (this.values[i2] instanceof Attribute[]) {
                v2.add(new DERTaggedObject(0, new DERSequence((Attribute[])this.values[i2])));
                continue;
            }
            v2.add(new DERTaggedObject(1, (AttributeCertificate)this.values[i2]));
        }
        return new DERSequence(v2);
    }
}

