/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.regression;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecomposition;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math.stat.regression.AbstractMultipleLinearRegression;

public class OLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private QRDecomposition qr = null;

    public void newSampleData(double[] y, double[][] x2) {
        this.validateSampleData(x2, y);
        this.newYSampleData(y);
        this.newXSampleData(x2);
    }

    public void newSampleData(double[] data, int nobs, int nvars) {
        super.newSampleData(data, nobs, nvars);
        this.qr = new QRDecompositionImpl(this.X);
    }

    public RealMatrix calculateHat() {
        RealMatrix Q = this.qr.getQ();
        int p2 = this.qr.getR().getColumnDimension();
        int n2 = Q.getColumnDimension();
        Array2DRowRealMatrix augI = new Array2DRowRealMatrix(n2, n2);
        double[][] augIData = augI.getDataRef();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                augIData[i2][j2] = i2 == j2 && i2 < p2 ? 1.0 : 0.0;
            }
        }
        return Q.multiply(augI).multiply(Q.transpose());
    }

    public double calculateTotalSumOfSquares() {
        if (this.isNoIntercept()) {
            return StatUtils.sumSq(this.Y.getData());
        }
        return new SecondMoment().evaluate(this.Y.getData());
    }

    public double calculateResidualSumOfSquares() {
        RealVector residuals = this.calculateResiduals();
        return residuals.dotProduct(residuals);
    }

    public double calculateRSquared() {
        return 1.0 - this.calculateResidualSumOfSquares() / this.calculateTotalSumOfSquares();
    }

    public double calculateAdjustedRSquared() {
        double n2 = this.X.getRowDimension();
        if (this.isNoIntercept()) {
            return 1.0 - (1.0 - this.calculateRSquared()) * (n2 / (n2 - (double)this.X.getColumnDimension()));
        }
        return 1.0 - this.calculateResidualSumOfSquares() * (n2 - 1.0) / (this.calculateTotalSumOfSquares() * (n2 - (double)this.X.getColumnDimension()));
    }

    protected void newXSampleData(double[][] x2) {
        super.newXSampleData(x2);
        this.qr = new QRDecompositionImpl(this.X);
    }

    protected RealVector calculateBeta() {
        return this.qr.getSolver().solve(this.Y);
    }

    protected RealMatrix calculateBetaVariance() {
        int p2 = this.X.getColumnDimension();
        RealMatrix Raug = this.qr.getR().getSubMatrix(0, p2 - 1, 0, p2 - 1);
        RealMatrix Rinv = new LUDecompositionImpl(Raug).getSolver().getInverse();
        return Rinv.multiply(Rinv.transpose());
    }
}

